<?php
get_header();
$pageTitle = get_the_title();

# GLOBAL
$color = get_field("gama_color");
$rooms = get_field("rooms", "options");

# BANNER
$image = get_field("image");
$title = get_field("title");
$text = get_field("text");

# INTRO
$intro = get_field("intro");
$introImage = get_field("intro_image");

# MODELS
$models = get_field("models");
$modelsTitle = get_field("models_title");
?>

<?php /******** BANNER ********/ ?>
<section id="banner-gama" class="banner pt-6 md:pt-20">
    <div class="relative">
        <div class="main-container block md:flex md:justify-end">
            <div class="animate slide-left image relative w-full md:h-[620px] xl:h-[720px] lg:w-[80%] xl:w-[70%] aspect-video bg-gray overflow-hidden bg-lightGrey">
                <?php if (isset($image) && $image["url"]) : ?>
                    <img src="<?= $image["url"] ?>" alt="<?= $image["alt"] ?>" class="h-full w-full object-cover" />
                <?php endif; ?>
                <div class="absolute inset-0 border-b-4 bg-gradient-to-t from-[<?= $color ? $color : "#EEE"; ?>]/70 to-white/0" style="border-color: <?= $color ? $color : "#EEE"; ?>"></div>
            </div>
            <div class="bg-darkBlue relative md:absolute md:bottom-0 md:left-0 md:translate-y-1/2 md:w-[80%] lg:bottom-[unset] lg:-translate-y-1/2 lg:top-1/2 lg:w-2/3 xl:w-1/2">
                <div class="animate slide-right left-padding pt-8 pr-6 md:pt-16 pb-24 lg:py-24 md:pr-20 relative">
                    <h2 class="text-white text-5xl font-semibold mb-10"><?= $title ? $title : $pageTitle; ?></h2>
                    <p class="text-white max-w-sm mb-10 md:mb-0 "><?= $text; ?></p>
                    <a href="#models" class="button relative md:absolute md:bottom-0 md:translate-y-1/2"><?php _e("Os nossos modelos", "clickhouse-theme"); ?></a>
                </div>
            </div>
            <div class="hidden md:inline-block absolute bottom-0 origin-bottom left-0 -translate-y-full lg:translate-y-1/3 scale-50 lg:left-1/4 xl:scale-100">
                <img src="<?= get_template_directory_uri() . "/assets/icons/plant_model_01.png" ?>" alt="" class="animate slide-left opacity-0 delay-400" />
            </div>
        </div>
    </div>
</section>

<?php /******** INTRO ********/ ?>
<?php if (isset($intro)) : ?>
    <section id="intro-gama" class="mt-20 md:mt-60 lg:mt-40 mb-20">
        <div class="main-container">
            <div class="flex items-center w-full flex-col lg:flex-row">
                <?php if ($introImage && $introImage["url"]) : ?>
                    <div class="animate slide-right flex-1 pb-20 text-center lg:text-left lg:pr-20 lg:pb-0">
                        <img src="<?= $introImage["url"]; ?>" alt="<?= $introImage["alt"]; ?>" class="w-full" />
                    </div>
                <?php endif; ?>
                <div class="animate slide-left flex-1">
                    <?php if ($intro["title"]) : ?>
                        <h3 class="font-bold text-darkBlue text-2xl mb-2"><?= $intro["title"]; ?></h3>
                    <?php endif; ?>
                    <?php if ($intro["subtitle"]) : ?>
                        <p class="font-bold text-darkBlue text-lg mb-2"><?= $intro["subtitle"]; ?></p>
                    <?php endif; ?>
                    <?php if ($intro["description"]) : ?>
                        <p class="mt-8 text-darkBlue"><?= $intro["description"]; ?></p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /******** MODELS ********/ ?>
<?php if (isset($models) && is_array($models) && count($models)) : ?>
    <section id="models" class="overflow-hidden">
        <div class="main-container">
            <h3 class="animate fade-in font-bold text-darkBlue text-5xl mb-20"><?php echo wpautop($modelsTitle); ?></h3>
            <div class="flex flex-col">
                <?php foreach ($models as $key => $model) : ?>
                    <div class="animate <?= $key % 2 === 0 ? "slide-right" : "slide-left" ?> w-full px-0 relative sm:px-10 md:px-14 lg:px-20 xl:px-40 mb-12 sm:mb-24 lg:mb-32">
                        <div class="relative w-full py-12 px-10 lg:px-16 flex flex-col" style="background-color: <?= $color ? $color . "80" : "#EEEEEE80"; ?>">
                            <div>
                                <h4 class="font-bold text-darkBlue text-2xl mb-10"><?= $model["title"]; ?></h4>
                            </div>
                            <div class="flex z-10 flex-col md:flex-row-reverse">
                                <div class="w-full md:w-1/3 text-center flex flex-col justify-between">
                                    <div>
                                        <?php if ($model["image"] && $model["image"]["url"]) : ?>
                                            <img src="<?= $model["image"]["url"]; ?>" class="origin-bottom scale-[1.2] mb-10 md:origin-bottom md:scale-[2]" />
                                        <?php endif; ?>
                                    </div>
                                    <div class="hidden md:block">
                                        <?php if ($model["document"] && $model["document"]["url"]) : ?>
                                            <a class="button outlined" href="<?= $model["document"]["url"]; ?>" download>
                                                <img src="<?= get_template_directory_uri() . "/assets/icons/download.svg" ?>" />
                                                <span><?php _e("descarregar", "clickhouse-theme"); ?></span>
                                            </a>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="w-full md:pr-20 md:w-2/3">
                                    <div class="columns-2 max-w-[360px] mx-auto md:max-w-none md:mx-0">
                                        <?php if (isset($rooms) && is_array($rooms) && count($rooms)) : ?>
                                            <?php foreach ($rooms as $room) : ?>
                                                <div class="flex items-start mb-8">
                                                    <div class="mr-4 pt-1 w-10">
                                                        <img src="<?= $room["image"]["url"]; ?>" className="mx-auto" />
                                                    </div>
                                                    <div>
                                                        <p class="text-xs opacity-50"><?= $room["title"]; ?></p>
                                                        <div class="text-sm"><?= wpautop($model["specs"][$room["key"]]); ?></div>
                                                    </div>
                                                </div>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="hidden absolute top-0 <?php echo $key % 2 === 0 ? "bottom-0 right-full" : "bottom-0 left-full" ?> w-8 lg:w-10 border-2 md:inline-block xl:w-20" style="border-color: <?= $color ? $color . "80" : "#EEEEEE80"; ?>"></div>
                            <div class="hidden absolute top-0 <?php echo $key % 2 === 0 ? "bottom-1/2 right-full" : "bottom-1/3 left-full" ?> w-16 lg:w-20 border-2 md:inline-block xl:w-40" style="border-color: <?= $color ? $color . "80" : "#EEEEEE80"; ?>"></div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php
get_template_part("parts/part-concepts");
get_template_part("parts/part-gamas");
get_template_part("parts/part-budget");

get_footer();
?>