<?php
get_header();

$icon = get_field("icon");
$color = get_field("color");

$text = get_field("text");
$image = get_field("image");
$video = get_field("video");

$introTitle = get_field("intro_title");
$introText = get_field("intro_text");

$aboutImage = get_field("about_image");
$aboutTitle = get_field("about_title");
$aboutText = get_field("about_text");

$artistImage = get_field("artist_image");
$artistText = get_field("artist_text");
$artistButton = get_field("artist_button");

$gallery = get_field("gallery");
$galleryText = get_field("gallery_text");

$aboutColoredImage = get_field("about_colored_image");
$aboutColoredTitle = get_field("about_colored_title");
$aboutColoredText = get_field("about_colored_text");

$reportActive = get_field("report_active");
$reportImage = get_field("report_image");
$reportTitle = get_field("report_title");
$reportText = get_field("report_text");

$descriptionImage = get_field("description_image");
$descriptionText = get_field("description_text");

?>

<section id="banner-concept" class="bg-conceptBlue pt-20 mb-20">
    <div class="main-container">
        <div class="flex max-w-5xl mx-auto flex-col md:flex-row">
            <div class="animate slide-right flex-1">
                <div class="w-full md:w-[420px]">
                    <h1 class="text-white font-bold text-5xl md:text-7xl leading-tight">
                        <?php the_title(); ?>
                        <?php if ($icon && $icon["url"]) : ?>
                            <span class="inline-flex w-12 items-center justify-center aspect-square rounded-full align-middle" style="background-color: <?= $color; ?>">
                                <img src="<?= $icon["url"]; ?>" alt="<?php the_title(); ?>" class="w-6 h-auto" />
                            </span>
                        <?php endif; ?>
                    </h1>
                </div>
            </div>
            <div class="animate slide-left flex-1">
                <div class="text-white pt-6 md:mb-6 text-xl">
                    <?= wpautop($text); ?>
                </div>
                <img src="<?= get_template_directory_uri() . "/assets/icons/lines_hero.svg" ?>" alt="<?php the_title(); ?>" class="origin-right scale-75 translate-y-12 md:translate-y-0 md:scale-100">
            </div>
        </div>
        <?php if (isset($image["url"])) : ?>
            <div class="animate slide-top">
                <div class="w-full aspect-video -mt-6 translate-y-6 md:mt-0 md:translate-y-20">
                    <img src="<?= $image["url"]; ?>" />
                    <div class="absolute inset-0 z-10 flex items-center justify-center">
                        <?php if (isset($video) && $video) : ?>
                            <button type="button" class="play-button main-transition hover:drop-shadow-lg">
                                <img src="<?= get_template_directory_uri() . "/assets/icons/play-filled.png" ?>" class="scale-50 md:scale-100" />
                            </button>
                        <?php endif; ?>
                    </div>
                    <div class="absolute inset-0 bg-gradient-to-b from-[<?= $color ? $color : "#EEE"; ?>]/70 to-white/0"></div>
                </div>
            </div>
        <?php endif; ?>
    </div>
    <?php if (isset($video) && $video) : ?>
        <div class="lightbox">
            <div class="video-player-front">
                <iframe width="1031" height="580" src="<?= $video; ?>?controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
            </div>
        </div>
    <?php endif; ?>
</section>

<?php if(isset($artistImage) || isset($artistText) || isset($artistButton)): ?>
    <section id="artist" class="pt-0 md:pt-20">
        <div class="main-container">
            <?php if(isset($artistImage) && isset($artistImage["url"])): ?>
                <div class="mb-10 md:mb-20">
                    <div class="animate slide-bottom mx-auto rounded-full aspect-square w-64 overflow-hidden border-8" style="border-color: <?= $color; ?>">
                        <img src="<?= $artistImage["url"]; ?>" class="w-full h-full object-cover" />
                    </div>
                </div>
            <?php endif; ?>
            <?php if(isset($artistText)): ?>
            <div class="animate slide-top mx-auto max-w-xl text-center text-base md:text-lg mb-14">
                <?= wpautop($artistText); ?>
            </div>
            <?php endif; ?>
            <?php if (isset($artistButton) && isset($artistButton["video"])): ?>
                <div class="text-center">
                    <button type="button" class="button animate slide-top play-button outlined" style="border-color: <?= $color; ?>; color: <?= $color; ?>;"><?= $artistButton["text"] ?></button>
                    <div class="lightbox">
                        <div class="video-player-front">
                            <iframe width="1031" height="580" src="<?= $artistButton["video"]; ?>?controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>
<?php endif; ?>

<?php if(isset($gallery) && is_array($gallery) && count($gallery)): ?>
<section id="gallery" class="pt-32 md:pt-20 pb-10 overflow-hidden">
    <div>
        <div class="list-gallery bg-darkBlue w-full mx-auto aspect-video max-w-xs md:max-w-md lg:max-w-xl xl:max-w-3xl">
            <?php foreach($gallery as $image): ?>
                <div>
                    <img src="<?= $image["url"]; ?>" alt="<?= $image["alt"]; ?>" />
                </div>
            <?php endforeach; ?>
        </div>
        <div class="text-center pt-4 pb-10 w-full mx-auto max-w-xs md:max-w-md md:pt-10 md:pb-20 lg:max-w-xl lg:pb-40 xl:max-w-3xl">
            <div class="text-md text-lightGrey px-12 md:px-0 md:text-2xl">
                <?= wpautop($galleryText); ?>
            </div>
        </div>
        <div class="w-full text-center">
            <a href="#ask-for-budget" class="button">
                <?php _e("Solicitar Orçamento", "clickhouse-theme"); ?>
            </a>
        </div>
    </div>
</section>
<?php endif; ?>

<section id="why-choose">

    <div class="main-container py-10 md:py-20">
        <div class="flex max-w-5xl mx-auto items-center flex-col md:flex-row">
            <div class="animate slide-right flex-1 mb-6 md:mb-0">
                <div class="font-bold text-darkBlue text-2xl pr-0 md:pr-16 md:text-3xl lg:pr-32">
                    <?= wpautop($introTitle); ?></div>
            </div>
            <div class="animate slide-left flex-1">
                <div class="text-lg opacity-80 md:text-xl md:leading-relaxed">
                    <?= wpautop($introText); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="flex items-center flex-col lg:flex-row">
        <?php if (isset($aboutImage["url"])) : ?>
            <div class="animate slide-right flex-1">
                <img src="<?= $aboutImage["url"]; ?>" class="w-full" />
            </div>
        <?php endif; ?>
        <div class="animate slide-left flex-1">
            <div class="right-padding pt-10 pl-6 md:pl-20 lg:pt-0 lg:pl-20">
                <h4 class="text-2xl font-bold text-darkBlue mb-4"><?= $aboutTitle; ?></h4>
                <div class="text-lg mb-6">
                    <?= wpautop($aboutText); ?>
                </div>
                <div>
                    <a href="#ask-for-budget" class="button btn-md">
                        <?php _e("Solicitar Orçamento", "clickhouse-theme"); ?>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="relative my-10 md:my-20">
        <div class="hidden absolute h-2/3 w-1/2 top-1/2 left-1/2 -translate-y-1/2 bg-gradient-to-r from-[<?= $color ? $color : "#EEE"; ?>] to-white/0 lg:block"></div>
        <div class="main-container relative">
            <div class="flex items-center flex-col lg:flex-row-reverse">
                <?php if (isset($aboutColoredImage["url"])) : ?>
                    <div class="flex-1 flex justify-end relative mb-8 lg:mb-0">
                        <div class="absolute h-2/3 w-11/12 bottom-10 left-1/12 bg-gradient-to-r from-[<?= $color ? $color : "#EEE"; ?>] to-white/0 lg:hidden"></div>
                        <img src="<?= $aboutColoredImage["url"]; ?>" class="animate slide-right w-full z-10" />
                    </div>
                <?php endif; ?>
                <div class="flex-1">
                    <div class="animate slide-left w-full pl-0 md:pl-14 lg:pl-0 lg:pr-20">
                        <h4 class="text-2xl font-bold text-[<?= $color ? $color : "#2b445b"; ?>] mb-4 lg:w-2/3"><?= $aboutColoredTitle; ?></h4>
                        <div class="text-lg mb-6 opacity-80">
                            <?= wpautop($aboutColoredText); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<section id="concept">
    <div class="flex items-center flex-col items-stretch bg-[#999]/20 lg:flex-row">
        <?php if (isset($descriptionImage["url"])) : ?>
            <div class="flex-1 align-self ">
                <img src="<?= $descriptionImage["url"]; ?>" class="animate slide-right w-full h-full object-cover" />
            </div>
        <?php endif; ?>
        <div class="flex-1 flex items-center py-14 xl:py-20 2xl:py-32">
            <div class="right-padding pl-6 lg:pl-20 animate slide-left">
                <?php if ($icon && $icon["url"]) : ?>
                    <span class="inline-flex w-12 items-center justify-center aspect-square rounded-full mb-10" style="background-color: <?= $color; ?>">
                        <img src="<?= $icon["url"]; ?>" alt="<?php the_title(); ?>" class="w-6 h-auto" />
                    </span>
                <?php endif; ?>
                <div class="text-base leading-relaxed mb-6 opacity-80">
                    <?= wpautop($descriptionText); ?>
                </div>
                <div>
                    <a href="#ask-for-budget" class="button btn-md">
                        <?php _e("Solicitar Orçamento", "clickhouse-theme") ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<?php if(isset($reportActive) && $reportActive): ?>
<section id="report" class="pt-20 pb-6">
    <div class="flex items-center flex-col lg:flex-row">
        <?php if (isset($reportImage["url"])) : ?>
            <div class="animate slide-right flex-1">
                <img src="<?= $reportImage["url"]; ?>" class="w-full" />
            </div>
        <?php endif; ?>
        <div class="animate slide-left flex-1">
            <div class="right-padding pt-10 pl-6 md:pl-6 lg:pt-0 lg:pl-20">
                <h4 class="text-2xl font-bold text-darkBlue mb-4"><?= $reportTitle; ?></h4>
                <div class="text-lg mb-6">
                    <?= wpautop($reportText); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>


<?php
get_template_part("parts/part-budget");
get_footer();
?>