<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes(); ?>>

<head profile="http://gmpg.org/xfn/11">
    <meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />

    <title><?php if (is_front_page()) { bloginfo('name'); } else { wp_title( '&middot;', true, 'right' ); bloginfo('name'); }  ?></title>

    <style type="text/css" media="screen">
        @import url( <?php bloginfo('stylesheet_url'); ?> );
    </style>

    <meta name="theme-color" content="#ffffff">
    <link rel="alternate" type="application/rss+xml" title="RSS 2.0" href="<?php bloginfo('rss2_url'); ?>" />
    <link rel="alternate" type="text/xml" title="RSS .92" href="<?php bloginfo('rss_url'); ?>" />
    <link rel="alternate" type="application/atom+xml" title="Atom 1.0" href="<?php bloginfo('atom_url'); ?>" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no" />
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">

    <?php
        wp_get_archives('type=monthly&format=link');
        wp_head();

        $logo = get_field("logo", "options");
        $logoB = get_field("logo_bottom", "options");

        $darkMenu = get_post_type() === "concept";

    ?>
  
</head>

<body>
  <header class="animate slide-bottom fixed top-0 left-0 right-0 z-50 border-b lg:border-b-0<?= $darkMenu ? " dark-menu" : "" ?>">
    <div class="main-container">
      <div class="flex justify-between py-4 flex-col lg:items-center lg:flex-row">
          <div class="flex justify-between z-10 mobile-nav">
            <div class="flex flex-col logo">
              <a href="<?= get_home_url(); ?>">
                <?php if(isset($logo) && $logo['url']): ?>
                  <img src="<?= $logo['url'] ?>" alt="<?= $logo['alt'] ?>" />
                <?php endif; ?>
                <?php if(isset($logoB) && $logoB['url']): ?>
                  <div class="logo-bottom">
                    <img src="<?= $logoB['url'] ?>" alt="<?= $logoB['alt'] ?>" />
                  </div>
                <?php endif; ?>
              </a>
            </div>
            <div class="flex items-center lg:hidden">
              <?php language_selector(); ?>
              <button class="menu-burguer" type="button">
                <img src="<?= get_template_directory_uri(). "/assets/icons/burguer_icon.png"; ?>" class="w-8" />
              </button>
            </div>
          </div>
          <div class="dropdown-menu flex items-center border-b left-0 right-0 absolute px-20 pb-10 top-full flex-col lg:flex-row lg:relative lg:p-0 lg:border-b-0">
            <?php clickhouse_menu(); ?>
            <div class="hidden lg:inline-block">
              <?php language_selector(); ?>
            </div>
          </div>
      </div>
    </div>
  </header>
  <main>
