
var gulp =  require('gulp'),
            sass = require('gulp-sass')(require('sass')),
            rename = require('gulp-rename'),
            concat = require('gulp-concat'),
            uglify = require('gulp-uglify'),
            browserSync = require('browser-sync'),
            minifyCSS = require('gulp-minify-css'),
            sourcemaps = require("gulp-sourcemaps"),
            autoprefixer = require('gulp-autoprefixer');

var src = {
    theme: 'wp-content/themes/clickhouse-theme/',
    url: 'http://localhost/clickhouse_new/',
    buildFolder: 'build/',
    watch: {
        mainSass: 'main.scss',
        sass: 'css/*.scss',
        scripts: 'scripts.js',
        js: 'js/*.js',
        php: '**/*.php'
    },
    folder: "assets/",
    dist: {
        folder: 'dist/',
        style: 'styles.min.css',
        script: 'scripts.min.js',
    }
}

gulp.task('serve', function(){
    browserSync.init([ 
        src.theme + src.watch.php, 
        src.theme + "*.php", 
        src.theme + src.dist.folder + '*.js' 
    ], {
        proxy: src.url,
        notify: true
    });    
});

gulp.task('watch', function() {
    gulp.watch(src.theme + src.buildFolder + src.watch.sass, gulp.series('sass'));
    // gulp.watch(src.theme + src.buildFolder + src.watch.scripts, gulp.series('minify'));
    gulp.watch(src.theme + src.folder + '*.css', gulp.series('minCss'));
    // gulp.watch(src.theme + src.folder.js  + '*.js',  gulp.series('concatJS'));
});

gulp.task('sass',  () => {
    return gulp.src([src.theme + src.buildFolder + src.watch.mainSass])
        .pipe(sourcemaps.init())
        .pipe(sass({outputStyle:'compressed'}))
        .pipe(concat('style.css'))
        .pipe(gulp.dest(src.theme + src.folder));
});

gulp.task('minCss', function() {
    return gulp.src([ src.theme + src.folder + '*.css' ])
        .pipe(minifyCSS())
        .pipe(autoprefixer('last 2 version', 'safari 5', 'ie 8', 'ie 9'))
        .pipe(concat(src.dist.style))
        .pipe(gulp.dest(src.theme + src.dist.folder))
        .pipe(browserSync.stream());
});


gulp.task('minify', function() {
    return gulp.src(src.theme + src.buildFolder + src.watch.scripts)
        .pipe(uglify())
        .pipe(gulp.dest(src.theme + src.folder));
});

gulp.task('concatJS', function() {
    return gulp.src([ src.theme + src.folder + '/scripts.js',  ])
        .pipe(concat('scripts.min.js'))
        .pipe(gulp.dest(src.theme + src.dist.folder))
        .pipe(uglify())
        .pipe(gulp.dest(src.theme + src.dist.folder));
});

gulp.task('default', gulp.parallel('sass', 'minCss', 'serve', 'watch'));