<?php
    // Template Name: Gama
    get_header();

    // BANNER
    $title = get_field('title');
    $text = get_field('text');
    $image = get_field('image');

    // ABOUT
    $aboutImage = get_field('about_image');
    $aboutDescription = get_field('about_description');
    
    // MODELS
    $models = get_field('models');
    $modelColor = get_field('model_color');
    $modelsTitle = get_field('models_title');

    // CONCEPTS
    $concepts = get_field('concepts');
    $conceptsTitle = get_field('concepts_title');
    $conceptsDescription = get_field('concepts_description');

    // GAMAS
    $gamas = get_field('gamas');
    $gamasTitle = get_field('gamas_title');
    $gamasDescription = get_field('gamas_description');
?>

<section class="Hero-Section">
    <div class="dark-bg-hero leftAni"></div>
    <div class="blueLine topAni"></div>
    <div class="blueLine2 topAni"></div>
    <div class="blueLine3 topAni"></div>

    <div class="container heroFlex">
        <div class="heroCTA">
            <h1 class="heroTitle gamas-comfort topAni"><?php echo $title; ?></h1>
            <p class="heroDescription gama-c topAni"><?php echo $text; ?></p>
            <a href="#asGamas"><button class="btnCTA topAni">Os Nossos Modelos</button></a>
        </div>
        <div class="heroImg leftAni">
            <?php if(isset($image) && is_array($image) && count($image)): ?>
                <img src="<?php echo $image['url'];?>" alt="<?php echo $image['alt'];?>" class="Hero-img" />
            <?php endif; ?>
        </div>
    </div>
</section>

<section class="processo p-section">
    <div id="gridWrappers" class="container container-padding">
        <div class="leftWrapper w-left">
            <div class="concept-description topAni">
                <?php echo wpautop($aboutDescription); ?>
            </div>
            <?php if(isset($aboutCatalog) && is_array($aboutCatalog) && count($aboutCatalog)): ?>
                <a href="<?php echo $aboutCatalog['url']; ?>" download>
                    <button class="PDF botAni"><img src="<?php bloginfo('template_directory');?>/assets/images/download_button_icon.svg" alt="" class="btn-d" /> Descarregar Catálogo</button>
                </a>
            <?php endif; ?>
        </div>
        <div class="rightWrapper w-right leftAni">
            <?php if(isset($aboutImage) && is_array($aboutImage) && count($aboutImage)): ?>
                <img id="promoVideo" src="<?php echo $aboutImage['url'];?>" alt="<?php echo $aboutImage['alt'];?>" class="responsive" />
            <?php endif; ?>
        </div>
    </div>
</section>

<section id="asGamas" class="modelos">
    <div class="container container-padding">
        <h2 class="mainTitle topAni"><?php echo $modelsTitle; ?></h2>

        <?php if(isset($models) && is_array($models) && count($models)): ?>
            <div class="list-models">
                <?php foreach($models as $model): ?>

                    <div class="grid-m">
                        <div class="border topAni" style="border-color: <?php echo $modelColor; ?>;"></div>
                        <div class="border topAni" style="border-color: <?php echo $modelColor; ?>;"></div>
            
                        <div class="background-m leftAni" style="background-color: <?php echo $modelColor; ?>;">
                            <p class="m-titulo botAni"><?php echo $model['title']; ?></p>
            
                            <?php if($model['specs']): ?>
                                
                                    <?php if($model['specs']['total_area']): ?>
                                        <div class="icon-m1">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_total_area_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Área Total</p>
                                                <div class="area"><?php echo $model['specs']['total_area']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                    
                                    <?php if($model['specs']['bedroom']): ?>
                                        <div class="icon-m2">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bedroom_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Quartos</p>
                                                <div class="area"><?php echo $model['specs']['bedroom']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                    
                                    <?php if($model['specs']['bathroom']): ?>
                                        <div class="icon-m3">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bathroom_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Casa de Banho</p>
                                                <div class="area"><?php echo $model['specs']['bathroom']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                    
                                    <?php if($model['specs']['room']): ?>
                                        <div class="icon-m4">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_living_room_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Sala</p>
                                                <div class="area"><?php echo $model['specs']['room']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                    
                                    <?php if($model['specs']['kitchen']): ?>
                                        <div class="icon-m5">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_kitchen_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Cozinha</p>
                                                <div class="area"><?php echo $model['specs']['kitchen']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                    
                                    <?php if($model['specs']['porch']): ?>
                                        <div class="icon-m6">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_porch_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Alpendre</p>
                                                <div class="area"><?php echo $model['specs']['porch']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                    
                                    <?php if($model['specs']['hall']): ?>
                                        <div class="icon-m7">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_hall_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Circulação</p>
                                                <div class="area"><?php echo $model['specs']['hall']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($model['specs']['pantry']): ?>
                                        <div class="icon-m8">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_pantry_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Despensa</p>
                                                <div class="area"><?php echo $model['specs']['pantry']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>

                                    <?php if($model['specs']['laundry']): ?>
                                        <div class="icon-m9">
                                            <div class="img-g">
                                                <img src="<?php bloginfo('template_directory');?>/assets/images/model_laundry_icon.svg" alt="" />
                                            </div>
                                            <div class="area-p">
                                                <p class="area-t">Lavandaria</p>
                                                <div class="area"><?php echo $model['specs']['laundry']; ?></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                
                            <?php endif; ?>

                            <?php if(isset($model['catalog']) && is_array($model['catalog']) && count($model['catalog'])): ?>
                            <div class="button-pdf">
                                <a href="<?php echo $model['catalog']['url']; ?>" download>
                                    <img src="<?php bloginfo('template_directory');?>/assets/images/download_button_icon.svg" alt="" class="btn-d" /> Descarregar Planta
                                </a>
                            </div>
                            <?php endif; ?>
                        </div>

                        <?php if(isset($model['image']) && is_array($model['image']) && count($model['image'])): ?>
                            <img src="<?php echo $model['image']['url']; ?>" alt="<?php echo $model['image']['url']; ?>" class="img-ga leftAni" />
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</section>

<section class="conceitos-list personalize botAni">
    <div class="container container-padding">
        <div class="grid-p">
            <img src="<?php bloginfo('template_directory');?>/assets/images/interrogation_mark_icon.svg" alt="" class="int-mark leftAni" />
            <h4 class="whiteTitle botAni"><?php echo $conceptsTitle;?></h4>
            <p class="wBodyTxt botAni"><?php echo $conceptsDescription;?></p>
            <a href="#orcamento" class="btnOrcamento"><button class="blueButton botAni">Pedir Orçamento</button></a>

            <?php if(isset($concepts) && is_array($concepts) && count($concepts)): ?>
                <?php foreach($concepts as $concept): ?>
                    <div class="box topAni" style="border-color: <?php echo $concept['color']; ?>;">
                        <?php if(isset($concept['link']) && $concept['link']): ?><a href="<?php echo $concept['link']; ?>"><?php endif; ?>
                            <?php if(isset($concept['icon']) && is_array($concept['icon']) && count($concept['icon'])): ?>
                                <img src="<?php echo $concept['icon']['url']; ?>" alt="<?php echo $concept['icon']['alt']; ?>" class="neo-icon" />
                            <?php endif; ?>
                            <h5 class="conceito-t"><?php echo $concept['title']; ?></h5>
                            <p class="conceito-b"><?php echo $concept['text'];?></p>
                            <?php if(isset($concept['link']) && $concept['link']): ?></a><?php endif; ?>
                        </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>

<section id="homeGamas" class="Gamas-section">
    <div class="container container-padding">
        <h2 class="mainTitle topAni"><?php echo $gamasTitle; ?></h2>
        <p id="gamasP" class="bodyText topAni"><?php echo $gamasDescription; ?></p>
        <div class="grid-container">
            <?php if(isset($gamas) && is_array($gamas) && count($gamas)): ?>
                <?php foreach($gamas as $gama): ?>
                    <div class="grid-item gamas topAni">
                        <a href="<?php echo get_permalink(10); ?>">
                            <?php if(isset($gama['image']) && is_array($gama['image']) && count($gama['image'])): ?>
                                <img src="<?php echo $gama['image']['url']; ?>" alt="<?php echo $gama['image']['alt']; ?>" class="responsive" />
                            <?php endif; ?>
                            <div class="colorBar" style="background-color: <?php echo $gama['color']; ?>"></div>
                            <div class="grid-text">
                                <h3 class="TitleSecondary"><?php echo $gama['title']; ?></h3>
                                <div class="gamaDetail"><?php echo wpautop($gama['description']); ?></div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>
</section>

<section id="orcamento" class="form-section">
  <div class="container form">
      <div class="after-padding topAni">
          <h2 id="form-g-t" class="mainTitle topAni">Peça já um Orçamento Gratuito</h2>
          <div class="form-container">
              <?php echo do_shortcode('[contact-form-7 id="494" title="Formulário de Orçamento"]'); ?>
          </div>
      </div>
  </div>
</section>


<script type="text/javascript">
    window.onload = function() {
        document.getElementById("concept-title").value = '<?php echo get_the_title(); ?>'; 
    };
</script>

<?php 
    get_footer();
?>