<?php
    /* Template Name: Feng-Shui */
    get_header();

    $hero = get_field('hero');
    $concept_main = get_field('conceito_main');
    $main_model = get_field('main_conceito');
    $link = isset($concept_main) && is_array($concept_main) && count($concept_main) && isset($concept_main['link_da_planta']) ? $concept_main['link_da_planta'] : null;
    $concept_main = get_field('conceito_main');
    $casa_render = get_field('main_conceito');
    $youtubeCode = get_field('youtubeCode');

?>
<section class="concept-hero">
    <div class="container container-padding">
        <div class="c-wrapper">
            <div class="concept-title-wrapper">
                <h1 class="concept-title leftAni">
                    <?php echo $hero['texto_header'];?>
                    <img src="<?php echo $hero['icone_conceito'];?>" alt="" class="cc-icone">
                </h1>
            </div>
            <div class="description-concept-wrapper topAni">
                <p class="description-p"><?php echo $hero['sub_head_concept'];?></p>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/lines_hero.svg" alt="" class="hero-lines">
            </div>
        </div>
        <div class="concept-image-video leftAni">
            <img src="<?php echo $hero['hero_image_concept'];?>" alt="" class="playerIMG">
            <?php if($youtubeCode): ?>
                <button type="button" class="conceptBtn">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/ICON-PLAY.png" alt="" class="play-button-cc">
                </button>
            <?php endif; ?>
            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/line_hero_left.svg" alt="" class="line-hero-left">  
        </div>
    </div>
</section>

<section class="fold">
    <div class="container container-padding feng-fold">
        <div class="cc-wrapper-feng">
            <div class="img-profile-feng botAni">
                <img src="<?php echo $concept_main['foto_'];?>" alt="" class="feng-responsive">
            </div>   
            <p class="feng-shui-descript botAni"><?php echo $concept_main['descript_title'];?></p>
            <?php if($concept_main['site_link'] && $concept_main['site_link']['url']): ?>
                <a href="<?php echo $concept_main['site_link']['url'];?>" target="_blank" class="btn-orcamento fengshui-btn botAni"><span>Veja o nosso vídeo</span></a>
            <?php endif; ?>
        </div>
    </div>
</section>

<section class="fotos-variadas">
    <div class="images-main-wrapper">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Group 36.png" alt="" class="img1-absolute">
        <div class="img-2">
            <img src="<?php echo $concept_main['imagem_grande_meio'];?>" alt="" class="main-big topAni">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Feng-Shui.png" alt="" class="p-image topAni">  
        </div>
        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/Group 38.png" alt="" class="img-absolute-cc topAni">
    </div>
    <div class="projetar-casa-harmoniosa">
        <p class="harmony-p botAni">Projetaremos uma casa funcional e harmoniosa.</p>
    </div>
    <div class="flex-center-btn">
        <a href="#orcamento" class="btn-orcamento"><span>Solicitar Orçamento</span></a>
    </div>
    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/planta-fheng-shui.svg" alt="" class="line-hero-left leftAni"> 
</section>

<section class="c-why-concept">
    <div class="c-wrapper-image leftAni">
        <img src="<?php echo $concept_main['feng_shui_render'];?>" alt="" class="responsive cc-feng-shui-image">
    </div>
    <div class="cc-grid-why">
        <div class="c-wrapper-main why-feng-shui">
            <div class="c-title topAni">
                <h3 class="c-concept-title"><?php echo $concept_main['texto_introducao_feng_shui'];?></h3>
            </div>
            <div class="c-under-title topAni">
                <?php echo $concept_main['introducao_feng_shui'];?>
            </div>
            <a href="#orcamento" class="btn-orcamento"><span>Solicitar Orçamento</span></a>
        </div>
    </div>
</section>

<section class="c-reflete">
    <div class="c-grid-container container-padding">
        <div class="image-concept-wrapper feng-shui-box leftAni">
            <div></div>
            <img src="<?php echo $casa_render['render_planta'];?>" alt="" class="cc-img" />
        </div>
        <div class="cc-txt-left">
            <div class="c-wrapper-text txt-padding topAni">
                <h4 class="c-title cc-title-feng"><?php echo $casa_render['planta_titulo'];?></h4>
            </div>
            <div class="c-wrapper-text topAni">
                <p class="body-text"><?php echo $casa_render['planta_descricao'];?></p>
            </div>
            <?php if(isset($casa_render['descarregar_planta']) && $casa_render['descarregar_planta']): ?>
                <a href="<?php echo $casa_render['descarregar_planta'];?>" class="planta-concept">
                    <span class="planta-span">Descarregar Planta</span>
                </a>
            <?php endif;?>
        </div>
    </div>
</section>

<section class="c-solicitar">
    <div class="wrapper-vw">
        <div class="c-img-wrpper">
            <img src="<?php echo $casa_render['imagem'];?>" alt="" class="c-img-solicitar feng-solicitar leftAni" />
        </div>
        <div class="c-box-right">
            <div class="c-icon-concept">
                <img src="<?php echo $casa_render['icone_do_conceito'];?>" alt="" class="cc-concept-icon topAni" />
            </div>
            <div class="c-box-text topAni">
                <p class="text-box"><?php echo $casa_render['descricao_final'];?></p>
            </div>
            <a href="#orcamento" class="btn-orcamento solicitar"><span>Solicitar Orçamento</span></a>

        </div>
    </div>
</section>

<section class="c-why-concept cc-book">
    <div class="c-wrapper-image leftAni">
        <img src="<?php echo $casa_render['beneficio-image'];?>" alt="" class="responsive cc-feng-shui-image">
    </div>
    <div class="cc-grid-why">
        <div class="c-wrapper-main why-feng-shui">
            <div class="c-title topAni">
                <h3 class="c-concept-title"><?php echo $casa_render['titulo_beneficio'];?></h3>
            </div>
            <div class="c-under-title topAni">
                <?php echo $casa_render['texto_beneficio'];?>
            </div>
        </div>
    </div>
</section>

<section id="orcamento" class="form-section">
    <div class="container form">
        <div class="after-padding topAni">
            <h2 id="form-g-t" class="mainTitle topAni">Peça já um Orçamento Gratuito</h2>
            <div class="form-container">
                <?php echo do_shortcode('[contact-form-7 id="494" title="Formulário de Orçamento"]'); ?>
            </div>
        </div>
    </div>
</section>

<?php if($youtubeCode): ?>
<div class="lightbox">
    <div class="video-player-front">
        <iframe width="1031" height="580" src="https://www.youtube.com/embed/<?php echo $youtubeCode; ?>?controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
    </div>
</div>
<?php endif; ?>
    
<style>
    .concept-image-video::after {
        background: linear-gradient(to bottom, <?php echo $casa_render["cor_da_caixa"]; ?> 0%, transparent 100%);
    }
    .image-concept-wrapper div {
        background: linear-gradient(to right, <?php echo $casa_render["cor_da_caixa"]; ?> 0%, transparent 100%);
    }
</style>

<script type="text/javascript">
    const conceptBtn = document.querySelector('.conceptBtn');
    const lightBox = document.querySelector('.lightbox');

    window.onload = function(){
        document.getElementById("concept-title").value = '<?php echo get_the_title(); ?>'; 

        if(conceptBtn) {
            conceptBtn.addEventListener('click', function () {
                lightBox.style.display = 'block';
                lightBox.addEventListener('click', function () {
                    lightBox.style.display = 'none';
                });
            });
        }
    };
</script>

<?php get_footer();?>