<?php
/* Template Name: Gama Elegant */

get_header();

$hero_zone_elegant = get_field('hero_gama_elegant');
$descricao_elegant = get_field('gama_descricao_elegant');

$gamas_section = get_field('conheca_as_gamas', 5);
$gama_selection = $gamas_section['gama_selection'];
$gama_comfort = $gamas_section['gama_comfort'];
$gama_elegant = $gamas_section['gama_elegant'];
$tiny_houses = $gamas_section['gama_tiny_houses']; 
?>

<section class="Hero-Section">
  <div class="dark-bg-hero leftAni"></div>
  <div class="blueLine topAni"></div>
  <div class="blueLine2 topAni"></div>
  <div class="blueLine3 topAni"></div>

  <div class="container heroFlex">
    <div class="heroCTA">
      <h1 class="heroTitle gamas-comfort gama-elegant topAni"><?php echo $hero_zone_elegant['titulo_gama'];?></h1>
      <p class="heroDescription gama-c topAni"><?php echo $hero_zone_elegant['descricao_da_gama'];?></p>
      <a href="#asGamas"><button class="btnCTA topAni">Os Nossos Modelos</button></a>
    </div>
    <div class="heroImg leftAni">
      <img src="<?php echo $hero_zone_elegant['foto_da_gama'];?>" alt="showroom Algarve" class="Hero-img" />
    </div>
  </div>
</section>

    <section class="processo p-section">
      <div id="gridWrappers" class="container container-padding">
        <div class="leftWrapper w-left">
          <h4 class="TitleSecondary topAni">
          <?php echo $descricao_elegant['pre-titulo_gama'];?>
          </h4>
          <p class="titleWrapper topAni">
          <?php echo $descricao_elegant['titulo_da_gama'];?>
          </p>
          <p class="mainParagraph topAni">
          <?php echo $descricao_elegant['paragraph_gama'];?>
          </p>
          <?php if(isset($descricao_elegant['catalog']) && $descricao_elegant['catalog']): ?>
          <a href="<?php echo $descricao_elegant['catalog']; ?>" download>
            <button class="PDF botAni">
              <img src="<?php bloginfo('template_directory');?>/assets/images/download_button_icon.svg" alt="" class="btn-d" /> Descarregar Catálogo
            </button>
          </a>
        <?php endif; ?>
        </div>
        <div class="rightWrapper w-right leftAni">
          <img
            id="promoVideo"
            src="<?php bloginfo('template_directory');?>/assets/images/promo_video_image_homepage.jpg"
            alt="image for promo video"
            class="responsive"
          />
        </div>
      </div>
      <!--<div id="btnGrid" class="btnWrapper">-->
      <!--<button class="promoBtn"><img src="images/play_button_icon_darkVersion.svg" alt="" class="playBtn">Ver o Vídeo Promocional</button>-->
      <!--<div class="btnBox"></div>-->
      <!--</div>-->
    </section>

    <section id="asGamas" class="modelos">
      <div class="container container-padding">
        <div class="grid-m">
          <div class="blue-l1 green-l orang-l topAni"></div>
          <div class="blue-l2 green-l orang-l topAni"></div>
          <h2 class="mainTitle topAni">
            Imagina-se a viver assim? Escolha o seu modelo ideal.
          </h2>
          <div class="background-m gama-green gama-orang leftAni">
            <p class="m-titulo botAni">Modelo 201</p>
            <div class="icon-m1">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_total_area_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Total Area</p>
                <p class="area">135<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m2">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bedroom_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Bedrooms</p>
                <p class="area">21,4<span>m2</span></p>
                <p class="area">10,8<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m3">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bathroom_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Bathrooms</p>
                <p class="area">8,6<span>m2</span></p>
                <p class="area">5,9<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m4">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_living_room_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Living Room</p>
                <p class="area">30,5<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m5">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_kitchen_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Kitchen</p>
                <p class="area">17,3<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m6">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_porch_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Porch</p>
                <p class="area">14,1<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m7">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_hall_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Hall</p>
                <p class="area">12,8<span>m2</span></p>
              </div>
            </div>
          </div>
          <img src="<?php bloginfo('template_directory');?>/assets/images/planta_elegantst_201.png" alt="" class="img-ga leftAni" />
        </div>

        <div class="grid-m">
          <div class="blue-l3 green-l orang-l topAni"></div>
          <div class="blue-l4 green-l orang-l topAni"></div>
          <div class="background-m gama-green gama-orang leftAni">
            <p class="m-titulo grid-m2 botAni">Modelo 301</p>
            <div class="icon-m1 grid-m2">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_total_area_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Total Area</p>
                <p class="area">154<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m2 grid-m2">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bedroom_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Bedrooms</p>
                <p class="area">21,4<span>m2</span></p>
                <p class="area">10,8<span>m2</span></p>
                <p class="area">15,4<span>m2</span></p>
              </div>
            </div>
            <div id="column-margin" class="icon-m3 grid-m2">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bathroom_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Bathrooms</p>
                <p class="area">8,6<span>m2</span></p>
                <p class="area">5,9<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m4 grid-m3">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_living_room_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Living Room</p>
                <p class="area">31,2<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m5 grid-m3">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_kitchen_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Kitchen</p>
                <p class="area">17,3<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m6 grid-m3">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_porch_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Porch</p>
                <p class="area">14,1<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m7 grid-m3">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_hall_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Hall</p>
                <p class="area">12,8<span>m2</span></p>
              </div>
            </div>
          </div>
          <img
            src="<?php bloginfo('template_directory');?>/assets/images/planta_elegant_st_301.png"
            alt=""
            class="img-ga ga2 leftAni"
          />
        </div>

        <div class="grid-m margin-g">
          <div class="blue-l5 green-l orang-l topAni"></div>
          <div class="blue-l6 green-l orang-l topAni"></div>
          <div class="background-m gama-green gama-orang leftAni">
            <p class="m-titulo botAni">Modelo 302</p>
            <div class="icon-m1">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_total_area_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Total Area</p>
                <p class="area">173<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m2">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bedroom_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Bedrooms</p>
                <p class="area">21,4<span>m2</span></p>
                <p class="area">10,8<span>m2</span></p>
                <p class="area">10,8<span>m2</span></p>
                <p class="area">15,4<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m3 m-401">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_bathroom_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Bathrooms</p>
                <p class="area">8,6<span>m2</span></p>
                <p class="area">5,9<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m4">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_living_room_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Living Room</p>
                <p class="area">31,2<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m5">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_kitchen_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Kitchen</p>
                <p class="area">17,3<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m6">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_porch_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Porch</p>
                <p class="area">14,1<span>m2</span></p>
              </div>
            </div>
            <div class="icon-m7">
              <div class="img-g">
                <img src="<?php bloginfo('template_directory');?>/assets/images/model_hall_icon.svg" alt="" />
              </div>
              <div class="area-p">
                <p class="area-t">Hall</p>
                <p class="area">17,3<span>m2</span></p>
              </div>
            </div>
          </div>
          <img
            src="<?php bloginfo('template_directory');?>/assets/images/planta_elegant_302.png"
            alt=""
            class="img-ga img-401 leftAni"
          />
        </div>
      </div>
    </section>
 <!--- PERSONALIZE --->

 <?php 
    $modelos_comfort = get_field('personalizar_modelo', 14);
    $cards_modelos = $modelos_comfort['modelos_cards'];?>
    ?>

    <section class="personalize botAni">
      <div class="container container-padding">
        <div class="grid-p">
          <img
            src="<?php bloginfo('template_directory');?>/assets/images/interrogation_mark_icon.svg"
            alt=""
            class="int-mark leftAni"
          />
          <h4 class="whiteTitle botAni"><?php echo $modelos_comfort['personalize_titulo'];?></h4>
          <p class="wBodyTxt botAni">
            <?php echo $modelos_comfort['descricao_personalize'];?>
          </p>
          <a href="#orcamento" class="btnOrcamento"><button class="blueButton botAni">Pedir Orçamento</button></a>
          <div class="box1-p topAni">
            <img src="<?php bloginfo('template_directory');?>/assets/images/neo_conceito_icon.svg" alt="" class="neo-icon" />
            <h5 class="conceito-t">Neo</h5>
            <p class="conceito-b">
              <?php echo $cards_modelos['card_neo'];?>
            </p>
          </div>
          <div class="box2-p topAni">
            <img src="<?php bloginfo('template_directory');?>/assets/images/safe_conceito_icon.svg" alt="" class="neo-icon" />
            <h5 class="conceito-t">Safe</h5>
            <p class="conceito-b">
              <?php echo $cards_modelos['card_safe'];?>
            </p>
          </div>
          <div class="box3-p topAni">
            <img
              src="<?php bloginfo('template_directory');?>/assets/images/feng_shui_conceito_icon.svg"
              alt=""
              class="neo-icon"
            />
            <h5 class="conceito-t">Feng Shui</h5>
            <p class="conceito-b">
            <?php echo $cards_modelos['card_feng_shui_descricao'];?>
            </p>
          </div>
        </div>
      </div>
    </section>


    <section id="homeGamas" class="Gamas-section">
      <div class="container container-padding">
        <h2 class="mainTitle topAni">Conheça as Gamas.</h2>
        <p id="gamasP" class="bodyText topAni">
          <?php echo $gamas_section['conheca_as_gamas_subtitulo'];?>
        </p>
        <div class="grid-container">
          <div class="grid-item gamas topAni"><a href="<?php echo get_permalink(10); ?>">
          <img src="<?php echo $gama_selection['imagem_da_gama1'];?>" alt="" class="responsive"/>
            <div class="colorBar box1"></div>
            <div class="grid-text">
            <h3 class="TitleSecondary"><?php echo $gama_selection['titulo_da_gama1'];?></h3>
            <p class="gamaDetail">
              <?php echo $gama_selection['subtitulo_da_gama1'];?>
            </p>
          </div></a>
          </div>
          <div class="grid-item gamas topAni"><a href="<?php echo get_permalink(14); ?>">
            <img src="<?php echo $gama_comfort['imagem_da_gama2'];?>" alt="" class="responsive"/>
            <div class="colorBar box2"></div>
            <div class="grid-text">
            <h3 class="TitleSecondary"><?php echo $gama_comfort['titulo_da_gama2'];?></h3>
            <p class="gamaDetail">
            <?php echo $gama_comfort['subtitulo_da_gama2'];?>
            </p>
          </div></a>
          </div>
          
          <div class="grid-item gamas topAni"><a href="<?php echo get_permalink(560); ?>">
            <img src="<?php echo $tiny_houses['imagem_da_gama4'];?>" alt="" class="responsive"/>
            <div class="colorBar box4"></div>
            <div class="grid-text">
            <h3 class="TitleSecondary"><?php echo $tiny_houses['titulo_da_gama_4'];?></h3>
            <p class="gamaDetail">
            <?php echo $tiny_houses['subtitulo_da_gama4'];?>
            </p>
          </div></a>
          </div>
        </div>
      </div>
      </section>

      <section id="orcamento" class="form-section">
  <div class="container form">
      <div class="after-padding topAni">
          <h2 id="form-g-t" class="mainTitle topAni">Peça já um Orçamento Gratuito</h2>
          <div class="form-container">
              <?php echo do_shortcode('[contact-form-7 id="494" title="Formulário de Orçamento"]'); ?>
          </div>
      </div>
  </div>
</section>


<script type="text/javascript">
    window.onload = function(){
        document.getElementById("concept-title").value = '<?php echo get_the_title(); ?>'; 
    };
</script>


    <?php get_footer();?>