<?php
  /* Template Name: Contactos */
  get_header();

  $hero_contacts = get_field('header_hero');
  $main_where = get_field('main_wrapper');
?>


<section class="Hero-Section">
  <div class="dark-bg-hero leftAni"></div>
  <div class="blueLine topAni"></div>
  <div class="blueLine2 topAni"></div>
  <div class="blueLine3 topAni"></div>

  <div class="container heroFlex">
    <div class="heroCTA">
      <h1 class="heroTitle topAni"><?php echo $hero_contacts['header_title'];?></h1>
      <p class="heroDescription chising-height topAni"><?php echo $hero_contacts['header_description'];?></p>
      <a href="#contactos"><button class="btnCTA topAni">Contacte-nos</button></a>
    </div>
    <div class="heroImg leftAni">
      <img src="<?php echo $hero_contacts['head_img'];?>" alt="showroom Algarve" class="Hero-img" />
    </div>
  </div>
</section>

<section class="contact-section">
  <div class="container container-padding">
    <div>
      <div>
        <?php if(isset($main_where['os_nossos_sitios']) && is_array($main_where['os_nossos_sitios']) && count($main_where['os_nossos_sitios'])): ?>
          <h2 class="mainTitle h-franchise topAni">As nossas casas modelo</h4>
          <div class="wrapper-location">
            <?php foreach($main_where['os_nossos_sitios'] as $place): ?>
              <div>
                <h3 class="mainTitle dist topAni"><?php echo $place['local'];?></h3>
                <img class="img-local" src="<?php echo $place['imagem_local'];?>" />
                <div class="wrappers-l">
                  <div class="wrapper-l-l topAni">
                    <h5 class="bodyText"><strong>Showroom</strong></h5>
                    <p class="bodyText"><?php echo $place['morada'];?></p>
                  </div>
                  <div class="wrapper-r-l topAni">
                    <h5 class="bodyText"><strong>Contacto</strong></h5>
                    <p class="bodyText"><?php echo $place['telefone'];?></p>
                    <p class="bodyText"><?php echo $place['email'];?></p>
                  </div>
                </div>
              </div>
            <?php endforeach; ?>
          </div>
          <?php endif; ?>
      </div>

      <div>
        <?php if(isset($main_where['os_nosso_franchisings']) && is_array($main_where['os_nosso_franchisings']) && count($main_where['os_nosso_franchisings'])): ?>
          <h2 class="mainTitle topAni">Os nossos Franchisings</h4>
          <div class="wrapper-franchise topAni">
            <?php foreach($main_where['os_nosso_franchisings'] as $place): ?>
              <p class="bodyText"><?php echo $place['local_franchise'];?></p>
            <?php endforeach; ?>
          </div>
          <?php endif; ?>
      </div>
    </div>
  </div>
</section>

<section class="form-section">
    <div class="container form">
        <div class="after-padding topAni">
            <h2 class="mainTitle">Entre em contacto</h2>
            <p class="bodyText">Qualquer que seja a dúvida ou solicitação, disponha sempre, a qualquer hora.</p>
            <p class="bodyText txtMargin"><strong>A nossa equipa entrará em contacto consigo.</strong></p>
            <div class="form-container">
                <?php echo do_shortcode('[contact-form-7 id="484" title="Formulário de contacto 1"]'); ?>
            </div>
        </div>
    </div>
</section>

<?php get_footer();?>