<?php 
    get_header();

    $page_for_posts = get_option('page_for_posts');

    $title = get_field('title', $page_for_posts);
    $text = get_field('text', $page_for_posts);
    $image = get_field('image', $page_for_posts);

    $listTitle = get_field('listTitle', $page_for_posts);
?>

<section class="Hero-Section">
    <div class="dark-bg-hero"></div>
    <div class="blueLine"></div>
    <div class="blueLine2"></div>
    <div class="blueLine3"></div>
    <div class="container heroFlex">
        <div class="heroCTA">
            <h1 class="heroTitle"><?php echo $title; ?></h1>
            <p class="heroDescription"><?php echo $text; ?></p> 
        </div>
        <div class="heroImg">
            <?php if(isset($image) && is_array($image) && count($image)): ?>
                <img src="<?php echo $image['url']; ?>" alt="<?php echo $image['alt']; ?>" class="Hero-img">
            <?php endif; ?>
        </div>
    </div>
</section>

<section class="all-blogs">
    <div class="container container-padding">
        <h2 class="archive-title mainTitle"><?php echo $listTitle; ?></h2>
        <div class="archives"><?php get_template_part('includes/section', 'archive');?></div>
    </div>
</section>
    
<?php get_footer();?>