<?php 


function load_stylesheet() {

    wp_register_style('mainCss', get_template_directory_uri() . '/assets/main.css', array(), 1);
    wp_enqueue_style('mainCss');

    wp_register_style('conceptsCss', get_template_directory_uri(). '/assets/concepts.css', array(), 1);
    wp_enqueue_style('conceptsCss');

    wp_register_style('fonts', 'https://fonts.googleapis.com/css2?family=DM+Sans:wght@700&family=Roboto:ital@0;1&display=swap', array(), null );
    wp_enqueue_style('fonts');
    
}

add_action( 'wp_enqueue_scripts', 'load_stylesheet' );





// LOAD SCRIPTS //

function load_scripts() {
    wp_register_script('script', get_template_directory_uri() . '/assets/script.js',  false, '1.0', true);
    wp_enqueue_script('script');
}

add_action( 'wp_enqueue_scripts', 'load_scripts' );


// MENU //

add_theme_support('menus');
add_theme_support('post-thumbnails');


register_nav_menus(

    array(

        'desktop-menu' => __('Desktop Menu', 'theme'),

    )

);

// BLOG

add_filter( 'excerpt_length', function($length) {
    return 30;
} );


// CUSTOM IMAGE SIZE

add_image_size('blog-small', 345, 245, true);


// ACF WYSIWYG 

function my_acf_add_local_field_groups() {
    remove_filter('acf_the_content', 'wpautop' );
}
add_action('acf/init', 'my_acf_add_local_field_groups');