const trigger = document.getElementsByClassName('acc-click');
const wrapper = document.querySelector('.acc-wrapper');
const change = document.querySelector('.acc-wrapper-change');
const arrow = document.querySelector('.acc-icon');
const deg = document.querySelector('.acc-deg');
const burguer = document.querySelector('.menu-toggle');
const linksM = document.querySelector('.links-m');
const navbar = document.querySelector('.navbar');
const promoBtn = document.querySelector('.promoBtn');
const demoBtn = document.querySelector('.demoBtn');
const lightBox = document.querySelector('.lightbox');
const lightBox2 = document.querySelector('.lightbox2');
const mobileDrop = document.querySelector('.dropdown-mobile');
const triggerDropdown = document.querySelector('.trigger');

gsap.registerPlugin(ScrollTrigger);



const triggerWrapper = document.querySelector('.wrapperImg');



gsap.from('.wall', {

  duration: 0.8,

  x: 80,

  opacity: 0,

  ease: ' expo. out',

  delay: 0.2,

  stagger: 0.3,

  scrollTrigger: {

    trigger: triggerWrapper,

    start: 'top center',

    toggleActions: 'play none none reverse',

    // markers: true,

  },

});



const triggerSection = document.querySelectorAll('section');



// gsap.from('#topAni', {

//   duration: 0.8,

//   y: -100,

//   opacity: 0,

//   ease: ' expo. out',



//   stagger: 0.3,

//   scrollTrigger: {

//     trigger: topAni,

//     start: 'top center',

//     toggleActions: 'play none none reset',

//     id="sectionScroll",

//     markers: false,

//   },

// });



triggerSection.forEach((topAnimate) => {

  const animateTop = topAnimate.querySelectorAll('.topAni');

  gsap.from(animateTop, {

    duration: 0.8,

    y: -100,

    opacity: 0,

    ease: ' expo. out',

    stagger: 0.3,

    scrollTrigger: {

      trigger: topAnimate,

      start: 'top bottom-=300',

      // toggleActions: 'play reset restart reverse',

      toggleActions: 'play none none none',

      // markers: true,

    },

  });

});



triggerSection.forEach((botAnimate) => {

  const animateBot = botAnimate.querySelectorAll('.botAni');

  gsap.from(animateBot, {

    duration: 0.8,

    y: 100,

    opacity: 0,

    ease: ' expo. out',

    delay: 1,

    stagger: 0.4,

    scrollTrigger: {

      trigger: botAnimate,

      start: 'top top+=100',

      // toggleActions: 'play reset restart reverse',

      toggleActions: 'play none none none',

      // markers: true,

    },

  });

});



triggerSection.forEach((leftAnimate) => {

  const aniLeft = leftAnimate.querySelectorAll('.leftAni');

  gsap.from(aniLeft, {

    duration: 0.8,

    x: -100,

    opacity: 0,

    ease: ' expo. out',

    delay: 0.5,

    stagger: 0.4,

    scrollTrigger: {

      trigger: leftAnimate,

      start: 'top center',

      // toggleActions: 'play reset restart reverse',

      toggleActions: 'play none none none',

      //markers: true,

    },

  });

});



gsap.from('.blueBG', {

  duration: 1,

  x: 300,

  opacity: 0,

  ease: 'power4.out',

  delay: 0,

  stagger: 0.3,

  scrollTrigger: {

    trigger: '.blueBG',

    start: 'top center',

    // toggleActions: 'play reset restart reverse',

    toggleActions: 'play none none none',

    //markers: true,

  },

});



const footer = document.querySelectorAll('footer');



gsap.from('.FooterBlock', {

  duration: 1,

  y: 150,

  opacity: 0,

  ease: 'power4.out',

  delay: 0,

  stagger: 0.3,

  scrollTrigger: {

    trigger: footer,

    start: 'top top',

    // toggleActions: 'play reset restart reverse',

    toggleActions: 'play none none none',

    // markers: true,

  },

});



for (i = 0; i < trigger.length; i++) {

  trigger[i].addEventListener('click', function () {

    var wrapper = this.nextElementSibling;



    wrapper.classList.toggle('acc-wrapper-change');



    let arrow = this.lastElementChild;

    arrow.classList.toggle('acc-deg');

  });

}









if(triggerDropdown) {
  triggerDropdown.addEventListener('click', function () {
  
    if (mobileDrop.style.height === '0px') {
  
      mobileDrop.style.height = '220px';
  
    } else {
  
      mobileDrop.style.height = '0px';
  
    }
  
  });
}


function toggleBacktoTop(val) {
  if(val >= 1000) {
      document.getElementById('backtotop').classList.remove('hide')
  } else {
      document.getElementById('backtotop').classList.add('hide')
  }
}


window.onload = function () {
  toggleBacktoTop(document.body.scrollTop);

  window.onscroll = function() {
    toggleBacktoTop(document.body.scrollTop);
  };

  burguer.addEventListener('click', function () {
    navbar.classList.toggle('opened');
    document.body.classList.toggle('opened');
  });

  document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    anchor.addEventListener('click', function (e) {
        e.preventDefault();
  
        if(this.getAttribute('href') == "#") {
          window.scroll({
            top: 0, 
            behavior: 'smooth' 
          });
        } else {
          document.querySelector(this.getAttribute('href')).scrollIntoView({
              behavior: 'smooth'
          });
        }
    });
  });


  if(promoBtn) {
    promoBtn.addEventListener('click', function () {
      lightBox.style.display = 'block';
      lightBox.addEventListener('click', function () {
        lightBox.style.display = 'none';
      });
    });
  }
  
  if(demoBtn) {
    demoBtn.addEventListener('click', function () {
      lightBox2.style.display = 'block';
      lightBox2.addEventListener('click', function () {
        lightBox2.style.display = 'none';
      });
    });
  }

}