<?php
/*
Plugin Name: Auto Compress Upload Image
Plugin URI: https://wordpress.org/plugins/auto-compress-upload-image/
Description: Automatically compress image after uploaded, Save storage and internet speed,optimize website access speed. 
Author: FastTools
Version: 1.0.0
Author URI: 
*/

$PLUGIN_VERSION = '1.0.0';


//add_action('admin_menu', 'acui_uploadresize_options_page');
//add_action('wp_handle_upload', 'acui_uploadresize_resize');
//add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'acui_generate_plugin_links');//for plugin settings page


function acui_uploadresize_resize($image_data){

  debug_log("**-start--resize-image-upload");

  $resizing_enabled = get_option('acui_resizeupload_resize_yesno');
  $resizing_enabled = ($resizing_enabled=='on') ? true : false;

  $force_jpeg_recompression = get_option('acui_resizeupload_recompress_yesno');
  $force_jpeg_recompression = ($force_jpeg_recompression=='yes') ? true : false;

  $compression_level = get_option('acui_resizeupload_quality');

  $max_width  = get_option('acui_resizeupload_width')==0 ? false : get_option('acui_resizeupload_width');

  $max_height = get_option('acui_resizeupload_height')==0 ? false : get_option('acui_resizeupload_height');


  $convert_png_to_jpg = get_option('acui_resizeupload_convertpng_yesno');
	$convert_png_to_jpg = ($convert_png_to_jpg=='yes') ? true : false;

  $convert_gif_to_jpg = get_option('acui_resizeupload_convertgif_yesno');
	$convert_gif_to_jpg = ($convert_gif_to_jpg=='yes') ? true : false;

  $convert_bmp_to_jpg = get_option('acui_resizeupload_convertbmp_yesno');
	$convert_bmp_to_jpg = ($convert_bmp_to_jpg=='yes') ? true : false;


  if($convert_png_to_jpg && $image_data['type'] == 'image/png' ) {
    $image_data = acui_uploadresize_convert_image( $image_data, $compression_level );
  }

  if($image_data['type'] == 'image/gif' && is_ani($image_data['file'])) {
    //animated gif, don't resize
    debug_log("--animated-gif-not-resized");
    return $image_data;
  }

  if($resizing_enabled || $force_jpeg_recompression) {

		$fatal_error_reported = false;
		$valid_types = array('image/gif','image/png','image/jpeg','image/jpg');

    if(empty($image_data['file']) || empty($image_data['type'])) {
    	debug_log("--non-data-in-file-( ".print_r($image_data, true)." )");	
		  $fatal_error_reported = true;
    }
    else if(!in_array($image_data['type'], $valid_types)) {
    	debug_log("--non-image-type-uploaded-( ".$image_data['type']." )");
		  $fatal_error_reported = true;
    }

    debug_log("--filename-( ".$image_data['file']." )");
    $image_editor = wp_get_image_editor($image_data['file']);
    $image_type = $image_data['type'];


    if($fatal_error_reported || is_wp_error($image_editor)) {
      debug_log("--wp-error-reported");
    }
    else {

      $to_save = false;
      $resized = false;


      // Perform resizing if required
      if($resizing_enabled) {

        debug_log("--resizing-enabled");
        $sizes = $image_editor->get_size();

        if((isset($sizes['width']) && $sizes['width'] > $max_width)
          || (isset($sizes['height']) && $sizes['height'] > $max_height)) {

          $image_editor->resize($max_width, $max_height, false);
          $resized = true;
          $to_save = true;

          $sizes = $image_editor->get_size();
          debug_log("--new-size--".$sizes['width']."x".$sizes['height']);
        }
        else {
          debug_log("--no-resizing-needed");
        }
      }
      else {
        debug_log("--no-resizing-requested");
      }

      if($force_jpeg_recompression && ($image_type=='image/jpg' || $image_type=='image/jpeg')) {

        $to_save = true;
        debug_log("--compression-level--q-".$compression_level);
      }
      elseif(!$resized) {
        debug_log("--no-forced-recompression");
      }

      if($to_save) {

        $image_editor->set_quality($compression_level);
        $saved_image = $image_editor->save($image_data['file']);
        debug_log("--image-saved");
      }
      else {
        debug_log("--no-changes-to-save");
      }
    }
  } 

  else {
    debug_log("--no-action-required");
  }

  debug_log("**-end--resize-image-upload\n");

  return $image_data;
} 

function acui_uploadresize_convert_image( $params, $compression_level ){
  $transparent = 0;
  $image = $params['file'];

  $contents = file_get_contents( $image );
  if ( ord ( file_get_contents( $image, false, null, 25, 1 ) ) & 4 ) $transparent = 1;
  if ( stripos( $contents, 'PLTE' ) !== false && stripos( $contents, 'tRNS' ) !== false ) $transparent = 1;

  $transparent_pixel = $img = $bg = false;
  if($transparent) {
    $img = imagecreatefrompng($params['file']);
    $w = imagesx($img); 
    $h = imagesy($img); 

    for($i = 0; $i<$w; $i++) {
      for($j = 0; $j < $h; $j++) {
        $rgba = imagecolorat($img, $i, $j);
        if(($rgba & 0x7F000000) >> 24) {
          $transparent_pixel = true;
          break;
        }
      }
    }
  }

  if( !$transparent || !$transparent_pixel) {
    if(!$img) $img = imagecreatefrompng($params['file']);
    $bg = imagecreatetruecolor(imagesx($img), imagesy($img));
    imagefill($bg, 0, 0, imagecolorallocate($bg, 255, 255, 255));
    imagealphablending($bg, 1);
    imagecopy($bg, $img, 0, 0, 0, 0, imagesx($img), imagesy($img));
    $newPath = preg_replace("/\.png$/", ".jpg", $params['file']);
    $newUrl = preg_replace("/\.png$/", ".jpg", $params['url']);
    for($i = 1; file_exists($newPath); $i++) {
      $newPath = preg_replace("/\.png$/", "-".$i.".jpg", $params['file']);
    }
    if ( imagejpeg( $bg, $newPath, $compression_level ) ){
      unlink($params['file']);
      $params['file'] = $newPath;
      $params['url'] = $newUrl;
      $params['type'] = 'image/jpeg';
    }
  }

  return $params;
}

function is_ani($filename) {
  if(!($fh = @fopen($filename, 'rb')))
    return false;
  $count = 0;
  $chunk = false;
  while(!feof($fh) && $count < 2) {
    $chunk = ($chunk ? substr($chunk, -20) : "") . fread($fh, 1024 * 100); //read 100kb at a time
    $count += preg_match_all('#\x00\x21\xF9\x04.{4}\x00(\x2C|\x21)#s', $chunk, $matches);
  }

  fclose($fh);
  return $count > 1;
}


function debug_log($message) {

  error_log(print_r($message, true));

}


if(get_option('acui_resizeupload_version') != $PLUGIN_VERSION) {

  add_option('acui_resizeupload_version', 			$PLUGIN_VERSION, '','yes');
  add_option('acui_resizeupload_width', 				'1200', '', 'yes');
  add_option('acui_resizeupload_height',				'1200', '', 'yes');
  add_option('acui_resizeupload_quality',				'90', '', 'yes');
  add_option('acui_resizeupload_resize_yesno', 		'on', '','on');
  add_option('acui_resizeupload_recompress_yesno', 	'no', '','yes');
  add_option('acui_resizeupload_convertbmp_yesno', 	'no', '', 'yes');
  add_option('acui_resizeupload_convertpng_yesno', 	'no', '', 'yes');
  add_option('acui_resizeupload_convertgif_yesno', 	'no', '', 'yes');
}


//add_action('admin_notices', 'acui_display_notices');
//add_action('wp_ajax_acui_dismiss_notices', 'acui_dismiss_notices');

function acui_generate_plugin_links($links) {
  $settings_link = '<a href="options-general.php?page=resize-after-upload">Settings</a>';
  array_unshift( $links, $settings_link );
  return $links;
}

function acui_display_notices() {
  if(get_option( 'acui_resizeupload_news') != 1 ) {
    global $acui_settings_page;
    $screen = get_current_screen();
    if ( $screen->id != $acui_settings_page ) { ?>
      <div class='notice notice-warning' id='jr-resizeupload-news' style="padding-top: 7px">
        <div style="float:right;"><a href="javascript:jrResizeuploadDismissNews()" class="button" style="margin-top:10px;">Dismiss</a></div>
        <strong>Resize Image After Upload</strong>
        <p>Check out the <a href="options-general.php?page=resize-after-upload">Plugin settings</a> for new features that can make your site load faster.</p>
      </div>
      <script>
        function jrResizeuploadDismissNews() {
          jQuery("#jr-resizeupload-news").hide();
          var data = { action  : 'acui_dismiss_notices'};
          jQuery.get('<?php echo admin_url('admin-ajax.php'); ?>', data, function(response) {
            data = JSON.parse(response);
            if(data["Status"] == 0) {
              console.log("dismissed");
            }
          });
        }
      </script>
    <?php }
  }
}

function acui_dismiss_notices() {
  update_option( 'acui_resizeupload_news', 1);
  die(json_encode(array("Status" => 0)));
}


function acui_uploadresize_options_page(){
    global $acui_settings_page;
	if(function_exists('add_options_page')){
      $acui_settings_page = add_options_page(
			'Auto Compress Upload Image',
			'Resize Image Upload',
			'manage_options',
			'resize-after-upload',
			'acui_uploadresize_options'
		);
	}
} // function acui_uploadresize_options_page(){



function acui_uploadresize_options(){

  if(isset($_POST['acui_options_update'])) {

      if(!(current_user_can('manage_options') &&
          wp_verify_nonce($_POST['_wpnonce'], 'jr-options-update'))) {
          wp_die("Not authorized");
      }

    $resizing_enabled = ($_POST['yesno'] == 'on' ? 'on' : 'off');
    $force_jpeg_recompression   = ($_POST['recompress_yesno'] == 'yes' ? 'yes' : 'no');

    $max_width   = intval($_POST['maxwidth']);
    $max_height  = intval($_POST['maxheight']);
    $compression_level    = intval($_POST['quality']);

    $convert_png_to_jpg = (isset($_POST['convertpng']) && $_POST['convertpng'] == 'yes' ? 'yes' : 'no');
    $convert_gif_to_jpg = (isset($_POST['convertgif']) && $_POST['convertgif'] == 'yes' ? 'yes' : 'no');
    $convert_bmp_to_jpg = (isset($_POST['convertbmp']) && $_POST['convertbmp'] == 'yes' ? 'yes' : 'no');


    $max_width = ($max_width == '') ? 0 : $max_width;
    $max_width = (ctype_digit(strval($max_width)) == false) ? get_option('acui_resizeupload_width') : $max_width;
    update_option('acui_resizeupload_width',$max_width);


    $max_height = ($max_height == '') ? 0 : $max_height;
    $max_height = (ctype_digit(strval($max_height)) == false) ? get_option('acui_resizeupload_height') : $max_height;
    update_option('acui_resizeupload_height',$max_height);


    $compression_level = ($compression_level == '') ? 1 : $compression_level;
    $compression_level = (ctype_digit(strval($compression_level)) == false) ? get_option('acui_resizeupload_quality') : $compression_level;

    if($compression_level < 1) {
    	$compression_level = 1;
    }
    else if($compression_level > 100) {
    	$compression_level = 100;
    }

    update_option('acui_resizeupload_quality',$compression_level);


    if ($resizing_enabled == 'on') {
      update_option('acui_resizeupload_resize_yesno','on'); }
    else {
      update_option('acui_resizeupload_resize_yesno','off'); }


    if ($force_jpeg_recompression == 'yes') {
      update_option('acui_resizeupload_recompress_yesno','yes'); }
    else {
      update_option('acui_resizeupload_recompress_yesno','no'); }


    if ($convert_png_to_jpg == 'yes') {
      update_option('acui_resizeupload_convertpng_yesno','yes'); }
    else {
      update_option('acui_resizeupload_convertpng_yesno','no'); }

    if ($convert_gif_to_jpg == 'yes') {
      update_option('acui_resizeupload_convertgif_yesno','yes'); }
    else {
      update_option('acui_resizeupload_convertgif_yesno','no'); }

    if ($convert_bmp_to_jpg == 'yes') {
      update_option('acui_resizeupload_convertbmp_yesno','yes'); }
    else {
      update_option('acui_resizeupload_convertbmp_yesno','no'); }



    echo('<div id="message" class="updated fade"><p><strong>Options have been updated.</strong></p></div>');
  } // if


  $resizing_enabled = get_option('acui_resizeupload_resize_yesno');
  $force_jpeg_recompression = get_option('acui_resizeupload_recompress_yesno');
  $compression_level  = intval(get_option('acui_resizeupload_quality'));

  $max_width     = get_option('acui_resizeupload_width');
  $max_height    = get_option('acui_resizeupload_height');

  $convert_png_to_jpg = get_option('acui_resizeupload_convertpng_yesno');
  $convert_gif_to_jpg = get_option('acui_resizeupload_convertgif_yesno');
  $convert_bmp_to_jpg = get_option('acui_resizeupload_convertbmp_yesno');
?>

<div class="wrap">
	<form method="post" accept-charset="utf-8">
		<h1><span style="margin-right:5px;"><img src="https://wp-theme.oss-us-west-1.aliyuncs.com/icon.png" width="64" height="64"/></span>
		Auto Compress Upload Image Config Options</h1>
		<hr style="margin-top:1px; margin-bottom:40px;">

		<table class="form-table">
			<tr>
				<th scope="row">Resize Image Switch :</th>
				<td valign="top">
					<select name="yesno" id="yesno">
						<option value="off" label="off" <?php echo ($resizing_enabled == 'off') ? 'selected="selected"' : ''; ?>>OFF</option>
						<option value="on" label="on" <?php echo ($resizing_enabled == 'on') ? 'selected="selected"' : ''; ?>>ON</option>
					</select>
				</td>
			</tr>

			<tr>
				<th scope="row">Resize Image Max Threshold :</th>
				<td>
					<fieldset><legend class="screen-reader-text"><span>Maximum width and height</span></legend>
						<label for="maxwidth">width</label>
						<input name="maxwidth" step="1" min="0" id="maxwidth" class="small-text" type="number" value="<?php echo $max_width; ?>">px
						&nbsp;&nbsp;&nbsp;<label for="maxheight">height</label>
						<input name="maxheight" step="1" min="0" id="maxheight" class="small-text" type="number" value="<?php echo $max_height; ?>">px
					</fieldset>
				</td>
			</tr>
			
			<tr>
				<th scope="row">Image Compression Ratio :</th>
				<td valign="top">
					<select id="quality" name="quality">
					<?php for($i=1; $i<=100; $i++) : ?>
						<option value="<?php echo $i; ?>" <?php if($compression_level == $i) : ?>selected<?php endif; ?>><?php echo $i; ?></option>
					<?php endfor; ?>
					</select>
					&nbsp;&nbsp;&nbsp;Recommended value: <code>90</code></p>
				</td>
			</tr>
			
		</table>

		<hr style="margin-top:20px; margin-bottom:30px;">

		<p class="submit" style="margin-top:10px;border-top:1px solid #eee;padding-top:20px;">
		  <input type="hidden" id="convert-bmp" name="convertbmp" value="no" />
          <input type="hidden" name="action" value="update" />
          <?php wp_nonce_field('jr-options-update'); ?>
		  <input id="submit" name="acui_options_update" class="button button-primary" type="submit" value="Update Options">
		</p>
	</form>

</div>

<style type="text/css">
.resizeimage-button {
  color: #FFF;
  background: none repeat scroll 0% 0% #FC9A24;
  border-radius: 3px;
  display: inline-block;
  border-bottom: 4px solid #EC8A14;
  margin-right:5px;
  line-height:1.05em;
  text-align: center;
  text-decoration: none;
  padding: 9px 20px 8px;
  font-size: 15px;
  font-weight: bold;
  text-shadow: 0 -1px 1px rgba(0,0,0,0.2);
}

.resizeimage-button:active,
.resizeimage-button:hover,
.resizeimage-button:focus {
  background-color: #EC8A14;
  color: #FFF;
}

.media-upload-form div.error, .wrap div.error, .wrap div.updated {
  margin: 25px 0px 25px;
}

</style>

<?php
} 




