<?php
// Template Name: 04 - Franchising
get_header();
$pageTitle = get_the_title();

# BANNER
$image = get_field("image");
$title = get_field("title");
$text = get_field("text");
$buttonText = get_field("button_text");

# INTRO
$introTitle = get_field("intro_title");
$introText = get_field("intro_text");
$introImage = get_field("intro_image");

# BLOCKS
$leftBlock = get_field("left_block");
$rightBlock = get_field("right_block");

?>

<?php /******** BANNER ********/ ?>
<section id="banner-gama" class="banner pt-6 md:pt-20">
  <div class="relative">
    <div class="main-container block md:flex md:justify-end">
      <div class="animate slide-left image relative w-full md:h-[620px] xl:h-[720px] lg:w-[80%] xl:w-[70%] aspect-video bg-gray overflow-hidden bg-lightGrey">
        <?php if (isset($image) && $image["url"]) : ?>
          <img src="<?= $image["url"] ?>" alt="<?= $image["alt"] ?>" class="h-full w-full object-cover" />
        <?php endif; ?>
      </div>
      <div class="bg-darkBlue relative md:absolute md:bottom-0 md:left-0 md:translate-y-1/2 md:w-[80%] lg:bottom-[unset] lg:-translate-y-1/2 lg:top-1/2 lg:w-2/3 xl:w-1/2">
        <div class="animate slide-right left-padding pt-8 pr-6 md:pt-16 pb-24 lg:py-24 md:pr-20 relative">
          <h2 class="text-white text-5xl font-semibold mb-10"><?= $title ? $title : $pageTitle; ?></h2>
          <p class="text-white max-w-sm mb-10 md:mb-0 "><?= $text; ?></p>
          <?php if (isset($buttonText) && $buttonText) : ?>
            <a href="#ask-for-budget" class="button relative md:absolute md:bottom-0 md:translate-y-1/2"><?= $buttonText; ?></a>
          <?php endif; ?>
        </div>
      </div>
      <div class="hidden md:inline-block absolute bottom-0 origin-bottom left-0 -translate-y-full lg:translate-y-1/3 scale-50 lg:left-1/4 xl:scale-100">
        <img src="<?= get_template_directory_uri() . "/assets/icons/plant_model_01.png" ?>" alt="" class="animate slide-left opacity-0 delay-400" />
      </div>
    </div>
  </div>
</section>

<?php /******** INTRO ********/ ?>
<?php if (isset($introTitle)) : ?>
  <section id="intro" class="mt-20 md:mt-60 lg:mt-40 mb-20">
    <div class="main-container">
      <div class="flex items-center w-full flex-col lg:flex-row">
        <?php if (isset($introImage) && isset($introImage["url"])) : ?>
          <div class="animate slide-right flex-1 mt-20 text-center relative lg:text-left lg:mb-0">
            <img src="<?= $introImage["url"]; ?>" alt="<?= $introImage["alt"]; ?>" class="w-full" />
          </div>
        <?php endif; ?>
        <div class="animate slide-left flex-1 pt-10 pl-0 lg:pt-0 lg:pl-20">
          <?php if ($introTitle) : ?>
            <h3 class="font-bold text-2xl mb-2"><?= $introTitle; ?></h3>
          <?php endif; ?>
          <?php if ($introText) : ?>
            <p class="mt-8"><?= $introText; ?></p>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </section>
  <?php ?>
<?php endif; ?>

<section id="dna">
  <div class="main-container">
    <div class="flex flex-col gap-10 lg:gap-14 lg:flex-row xl:gap-20">
      <?php if (isset($leftBlock)) : ?>
        <div class="animate slide-top flex-1">
          <?php if (isset($leftBlock["title"])) : ?>
            <h3 class="text-darkBlue text-4xl font-bold mb-3 lg:w-2/3 lg:mb-8"><?= $leftBlock["title"]; ?></h3>
          <?php endif; ?>
          <?php if (isset($leftBlock["text"])) : ?>
            <div class="text-base leading-relaxed editor"><?= wpautop($leftBlock["text"]); ?></div>
          <?php endif; ?>
        </div>
      <?php endif; ?>
      <?php if (isset($rightBlock)) : ?>
        <div class="animate slide-top flex-1">
          <?php if (isset($rightBlock["title"])) : ?>
            <h3 class="text-darkBlue text-4xl font-bold mb-3 lg:w-2/3 lg:mb-8"><?= $rightBlock["title"]; ?></h3>
          <?php endif; ?>
          <?php if (isset($rightBlock["text"])) : ?>
            <div class="text-base leading-relaxed editor"><?= wpautop($rightBlock["text"]); ?></div>
          <?php endif; ?>
        </div>
      <?php endif; ?>
    </div>
  </div>
</section>

<?php
get_template_part("parts/part-budget");

get_footer();
?>