<?php
// Template Name: 03 - Contacts
get_header();
$pageTitle = get_the_title();

# BANNER
$image = get_field("image");
$title = get_field("title");
$text = get_field("text");
$buttonText = get_field("button_text");

# CONTACTS
$models = get_field("model_house");
$franchising = get_field("franchising");

?>

<?php /******** BANNER ********/ ?>
<section id="banner-gama" class="banner pt-6 md:pt-20">
  <div class="relative">
    <div class="main-container block md:flex md:justify-end">
      <div class="animate slide-left image relative w-full md:h-[620px] xl:h-[720px] lg:w-[80%] xl:w-[70%] aspect-video bg-gray overflow-hidden bg-lightGrey">
        <?php if (isset($image) && $image["url"]) : ?>
          <img src="<?= $image["url"] ?>" alt="<?= $image["alt"] ?>" class="h-full w-full object-cover" />
        <?php endif; ?>
      </div>
      <div class="bg-darkBlue relative md:absolute md:bottom-0 md:left-0 md:translate-y-1/2 md:w-[80%] lg:bottom-[unset] lg:-translate-y-1/2 lg:top-1/2 lg:w-2/3 xl:w-1/2">
        <div class="animate slide-right left-padding pt-8 pr-6 md:pt-16 pb-24 lg:py-24 md:pr-20 relative">
          <h2 class="text-white text-5xl font-semibold mb-10"><?= $title ? $title : $pageTitle; ?></h2>
          <p class="text-white max-w-sm mb-10 md:mb-0"><?= $text; ?></p>
          <?php if (isset($buttonText) && $buttonText) : ?>
            <a href="#ask-for-budget" class="button relative md:absolute md:bottom-0 md:translate-y-1/2"><?= $buttonText; ?></a>
          <?php endif; ?>
        </div>
      </div>
      <div class="hidden md:inline-block absolute bottom-0 origin-bottom left-0 -translate-y-full lg:translate-y-1/3 scale-50 lg:left-1/4 xl:scale-100">
        <img src="<?= get_template_directory_uri() . "/assets/icons/plant_model_01.png" ?>" alt="" class="animate slide-left opacity-0 delay-400" />
      </div>
    </div>
  </div>
</section>

<section id="contacts" class="pt-20 md:pt-64 pb-20 lg:py-20">
  <?php if (isset($models)) : ?>
    <div class="main-container">
      <h3 class="animate fade-in text-darkBlue text-4xl mb-8 font-bold"><?= $models["title"]; ?></h3>
      <div class="flex flex-col md:flex-row md:gap-8">
        <?php foreach ($models["locations"] as $key => $location) : ?>
          <div class="animate slide-top delay-<?= $key + 1 . "00"; ?> w-full mb-10 md:mb-0 md:w-1/2 xl:w-1/3">
            <?php if (isset($location["name"])) : ?>
              <h4 class="text-darkBlue text-2xl mb-2 font-bold"><?= $location["name"]; ?></h4>
            <?php endif; ?>
            <?php if (isset($location["image"]) && isset($location["image"]["url"])) : ?>
              <img src="<?= $location["image"]["url"]; ?>" alt="<?= $location["image"]["url"]; ?>" />
            <?php endif; ?>
            <div class="flex gap-8">
              <div class="flex-1">
                <h6 class="font-semibold py-3 text-blackBlue"><?php _e("Showroom", "clickhouse-theme"); ?></h6>
                <?php if (isset($location["address"])) : ?>
                  <div class="text-darkBlue"><?= wpautop($location["address"]); ?></div>
                <?php endif; ?>
              </div>
              <div class="flex-1">
                <h6 class="font-semibold py-3 text-blackBlue"><?php _e("Contactos", "clickhouse-theme"); ?></h6>
                <div>
                  <ul>
                    <?php if (isset($location["phone_number"])) : ?>
                      <li><a href="tel:<?= $location["phone_number"] ?>" class="main-transition text-darkBlue hover:text-[#2ca2e3]"><?= $location["phone_number"] ?></a></li>
                    <?php endif; ?>
                    <?php if (isset($location["email"])) : ?>
                      <li><a href="emailto:<?= $location["email"] ?>" class="main-transition text-darkBlue hover:text-[#2ca2e3]"><?= $location["email"] ?></a></li>
                    <?php endif; ?>
                  </ul>
                </div>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  <?php endif; ?>

  <?php if (isset($franchising)) : ?>
    <div class="main-container mt-20">
      <h3 class="animate fade-in text-darkBlue text-4xl mb-8 font-bold"><?= $franchising["title"]; ?></h3>
      <div class="">
        <ul class="mt-2 sm:columns-2 xl:columns-3">
          <?php foreach ($franchising["locations"] as $location) : ?>
            <li class="animate slide-top text-darkBlue text-xl leading-relaxed"><?= $location["city"]; ?></li>
          <?php endforeach; ?>
        </ul>
      </div>
    </div>
  <?php endif; ?>
</section>


<?php
get_template_part("parts/part-budget");

get_footer();
?>