<?php
// Template Name: 02 - About
get_header();
$pageTitle = get_the_title();

# BANNER
$image = get_field("image");
$title = get_field("title");
$text = get_field("text");
$buttonText = get_field("button_text");

# INTRO
$intro = get_field("intro");
$introImage = get_field("intro_image");
$video = get_field("video");

# MISSION
$missionTitle = get_field("mission_title");
$missionImage = get_field("mission_image");
$missionList = get_field("list");

# FAQS
$faqsTitle = get_field("faqs_title");
$faqsText = get_field("faqs_text");
$faqs = get_field("faqs");

# SOCIALS
$socials = get_field("socials", "options");

# CONTACTS
$leftBlock = get_field("left_block");
$rightBlock = get_field("right_block");

?>

<?php /******** BANNER ********/ ?>
<section id="banner" class="banner pt-6 md:pt-20">
    <div class="relative">
        <div class="main-container block md:flex md:justify-end">
            <div class="animate slide-left image relative w-full md:h-[620px] xl:h-[720px] lg:w-[80%] xl:w-[70%] aspect-video bg-gray overflow-hidden">
                <?php if (isset($image) && $image["url"]) : ?>
                    <img src="<?= $image["url"] ?>" alt="<?= $image["alt"] ?>" class="h-full w-full object-cover" />
                <?php endif; ?>
            </div>
            <div class="bg-darkBlue relative md:absolute md:bottom-0 md:left-0 md:translate-y-1/2 md:w-[80%] lg:bottom-[unset] lg:-translate-y-1/2 lg:top-1/2 lg:w-2/3 xl:w-1/2">
                <div class="animate slide-right left-padding pt-8 pr-6 md:pt-16 pb-24 lg:py-24 md:pr-20 relative">
                    <h2 class="text-white text-5xl font-semibold mb-10"><?= $title ? $title : $pageTitle; ?></h2>
                    <p class="text-white max-w-sm mb-10 md:mb-0 "><?= $text; ?></p>
                    <?php if (isset($buttonText) && $buttonText) : ?>
                        <a href="#faqs" class="button relative md:absolute md:bottom-0 md:translate-y-1/2"><?= $buttonText ?></a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="hidden md:inline-block absolute bottom-0 origin-bottom left-0 -translate-y-full lg:-translate-y-1/3 scale-50 lg:left-1/4 xl:scale-100">
                <img src="<?= get_template_directory_uri() . "/assets/icons/plant_model_01.png" ?>" alt="" class="animate slide-left opacity-0 delay-400" />
            </div>
        </div>
    </div>
</section>

<?php /******** INTRO ********/ ?>
<?php if (isset($intro)) : ?>
    <section id="intro" class="mt-20 md:mt-60 lg:mt-40 mb-20">
        <div class="main-container">
            <div class="flex items-center w-full flex-col lg:flex-row">
                <div class="animate slide-right flex-1 pr-0 lg:pr-20">
                    <?php if ($intro["title"]) : ?>
                        <h3 class="font-bold text-2xl mb-2"><?= $intro["title"]; ?></h3>
                    <?php endif; ?>
                    <?php if ($intro["description"]) : ?>
                        <p class="mt-8"><?= $intro["description"]; ?></p>
                    <?php endif; ?>
                </div>
                <?php if (isset($introImage) && isset($introImage["url"])) : ?>
                    <div class="animate slide-left flex-1 mt-20 text-center relative lg:text-left lg:mb-0">
                        <img src="<?= $introImage["url"]; ?>" alt="<?= $introImage["alt"]; ?>" class="w-full" />
                        <?php if (isset($video) && isset($video["button_text"]) && isset($video["link"])) : ?>
                            <button type="button" class="play-button absolute bottom-0 left-1/2 translate-y-1/2 min-w-max whitespace-nowrap -translate-x-1/2 bg-white/80 flex items-center py-4 px-6 backdrop-blur-2xl hover:drop-shadow-lg">
                                <img src="<?= get_template_directory_uri() . "/assets/icons/play.svg" ?>" />
                                <span class="ml-4 text-darkBlue"><?= $video["button_text"]; ?></span>
                            </button>
                            <div class="lightbox">
                                <div class="video-player-front">
                                    <iframe width="1031" height="580" src="<?= $video["link"]; ?>?controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /******** MISSION ********/ ?>
<?php if (isset($missionTitle)) : ?>
    <section id="mission" class="bg-darkBlue text-white py-10 mt-20 mb-20 md:mt-60 md:py-20 lg:mt-40">
        <div class="main-container">
            <div class="flex justify-center mb-12">
                <h3 class="animate fade-in font-bold text-center text-4xl"><?= $missionTitle; ?></h3>
            </div>
            <div class="flex items-center w-full flex-col lg:flex-row">
                <?php if (isset($missionImage) && isset($missionImage["url"])) : ?>
                    <div class="animate slide-right flex-1 mb-10 text-center relative pr-0 lg:text-left lg:mb-0 lg:pr-20">
                        <img src="<?= $missionImage["url"]; ?>" alt="<?= $missionImage["alt"]; ?>" class="w-full" />
                    </div>
                <?php endif; ?>
                <div class="flex-1">
                    <?php if (isset($missionList) && is_array($missionList) && count($missionList)) : ?>
                        <div>
                            <?php foreach ($missionList as $item) : ?>
                                <div class="animate slide-top mb-8 last:mb-0">
                                    <h5 class="font-bold text-xl uppercase mb-2"><?= $item["title"]; ?></h5>
                                    <div class="text-sm text-white/80"><?= wpautop($item["text"]); ?></div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>
    <?php ?>
<?php endif; ?>

<?php /******** FAQS ********/ ?>
<?php if (isset($faqs) && is_array($faqs) && count($faqs)) : ?>
    <section id="faqs" class="my-20">
        <div class="main-container">
            <h3 class="animate slide-bottom font-bold text-4xl mb-2"><?= $faqsTitle; ?></h3>
            <div class="animate slide-bottom mb-8">
                <?= wpautop($faqsText); ?>
            </div>
            <div class="animate slide-top accordion lg:gap-8 lg:columns-2">
                <?php $i = 1;
                foreach ($faqs as $faq) : ?>
                    <div class="panel">
                        <input type="checkbox" id="chck<?= $i; ?>">
                        <label class="panel-label" for="chck<?= $i; ?>">
                            <div class="flex items-start">
                                <span class="bg-lightBlue inline-flex items-center justify-center text-white w-6 h-6 md:w-7 md:h-7 mr-2 text-sm aspect-square rounded-full"><?= $i; ?></span>
                                <span class="text-base md:pt-0.5"><?= $faq["question"]; ?></span>
                            </div>
                        </label>
                        <div class="panel-content text-sm">
                            <?= wpautop($faq["answer"]); ?>
                        </div>
                    </div>
                <?php $i++;
                endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /******** SECTIONS ********/ ?>
<?php if (isset($socials)) : ?>
    <section id="socials" class="bg-lightBlue">
        <div class="main-container">
            <div class="flex py-10 flex-col items-center md:flex-row-reverse md:justify-between">
                <div class="animate slide-left">
                    <ul class="flex gap-8 items-center">
                        <?php foreach ($socials as $social) : ?>
                            <?php if (isset($social["icon"]) && isset($social["icon"]["url"])) : ?>
                                <li class="inline-block">
                                    <a href="<?= $social["url"] ?>" target="_blank" rel="noopener noreferrer" class="aspect-square opacity-100 hover:opacity-80">
                                        <img src="<?= $social["icon"]["url"] ?>" alt="<?= $social["icon"]["alt"] ?>" class="h-8 w-auto" />
                                        <span class="hidden"><?= $social["name"] ?></span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <div class="animate slide-right w-full md:w-2/3">
                    <h4 class="font-bold text-white text-center text-2xl pt-6 md:pt-0 md:pr-20 md:text-left"><?php _e("Siga-nos nas redes sociais e mantenha-se informado!", "clickhouse-theme") ?></h4>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php /******** CONTACTS ********/ ?>
<section id="about-contacts">
    <div class="flex flex-col lg:flex-row-reverse">
        <?php if (isset($rightBlock)) : ?>
            <div class="flex-1 pt-24 pb-20">
                <div class="animate slide-bottom right-padding delay-200 pl-6 md:pl-8 lg:pl-20">
                    <?php if (isset($rightBlock["title"])) : ?>
                        <h4 class="text-darkBlue text-3xl font-bold"><?= $rightBlock["title"] ?></h4>
                    <?php endif; ?>
                    <?php if (isset($rightBlock["text"])) : ?>
                        <div class="mt-2 text-darkBlue md:w-2/3">
                            <?= wpautop($rightBlock["text"]); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($rightBlock["franchising"])) : ?>
                        <div class="mt-4">
                            <?php if (isset($rightBlock["franchising"]["title"])) : ?>
                                <h5 class="text-darkBlue text-2xl font-bold"><?= $rightBlock["franchising"]["title"] ?></h5>
                            <?php endif; ?>
                            <?php if (isset($rightBlock["franchising"]["locals"]) && is_array($rightBlock["franchising"]["locals"]) && count($rightBlock["franchising"]["locals"])) : ?>
                                <ul class="mt-2 columns-2 xl:columns-3">
                                    <?php foreach ($rightBlock["franchising"]["locals"] as $local) : ?>
                                        <li class="text-darkBlue leading-relaxed"><?= $local["name"]; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                            <?php if (isset($rightBlock["franchising"]["link"]) && isset($rightBlock["franchising"]["button_text"])) : ?>
                                <div class="mt-10">
                                    <a href="<?= $rightBlock["franchising"]["link"] ?>" class="button">
                                        <?= $rightBlock["franchising"]["button_text"] ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php if (isset($leftBlock)) : ?>
            <div class="relative flex-1 bg-darkBlue pt-24 pb-20">
                <div class="animate slide-top left-padding pr-6 md:pr-8 lg:pr-20">
                    <?php if (isset($leftBlock["title"])) : ?>
                        <h4 class="text-white text-4xl font-bold xl:w-2/3"><?= $leftBlock["title"] ?></h4>
                    <?php endif; ?>
                    <?php if (isset($leftBlock["contacts"])) : ?>
                        <div class="mt-6">
                            <ul>
                                <?php if (isset($leftBlock["contacts"]["phone_number"])) : ?>
                                    <li><a href="tel:<?= $leftBlock["contacts"]["phone_number"] ?>" class="main-transition text-white/80 hover:text-white"><?= $leftBlock["contacts"]["phone_number"] ?></a></li>
                                <?php endif; ?>
                                <?php if (isset($leftBlock["contacts"]["email"])) : ?>
                                    <li><a href="emailto:<?= $leftBlock["contacts"]["email"] ?>" class="main-transition text-white/80 hover:text-white"><?= $leftBlock["contacts"]["email"] ?></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($leftBlock["text"])) : ?>
                        <div class="mt-2 text-white/80">
                            <?= wpautop($leftBlock["text"]); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($leftBlock["button_link"]) && isset($leftBlock["button_text"])) : ?>
                        <div class="mt-10">
                            <a href="<?= $leftBlock["button_link"] ?>" class="button">
                                <?= $leftBlock["button_text"] ?>
                            </a>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="hidden lg:block absolute h-16 bg-darkBlue bottom-0 left-0 right-0 z-10 translate-y-full"></div>
            </div>
        <?php endif; ?>
    </div>
</section>

<?php
get_footer();
?>