<?php
  get_header();

  if (have_posts()) : 
    while (have_posts()) : the_post();

      $thumbnail = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
?>


<?php /******** BANNER ********/ ?>
<section id="banner-gama" class="banner pt-6 md:pt-20">
  <div class="relative">
    <div class="main-container block md:flex md:justify-end">
      <div class="animate slide-left image relative w-full md:h-[620px] xl:h-[720px] lg:w-[80%] xl:w-[70%] aspect-video bg-gray overflow-hidden bg-lightGrey">
        <?php if (has_post_thumbnail()) : ?>
          <img src="<?php the_post_thumbnail_url('blog-small'); ?>" alt="<?php the_title(); ?>" class="h-full w-full object-cover" />
        <?php endif; ?>
      </div>
      <div class="bg-darkBlue relative md:absolute md:bottom-0 md:left-0 md:translate-y-1/2 md:w-[80%] lg:bottom-[unset] lg:-translate-y-1/2 lg:top-1/2 lg:w-2/3 xl:w-1/2">
        <div class="animate slide-right left-padding pt-8 pr-6 md:pt-16 pb-24 lg:py-24 md:pr-20 relative">
          <h2 class="text-white text-5xl font-semibold"><?php the_title(); ?></h2>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="content">
    <div class="main-container pt-20 pb-40">
        <div class="editor max-w-5xl mx-auto">
            <span class="animate fade-in block mb-6 text-sm opacity-40"><?= get_the_date(); ?></span>
            <div class="animate slide-top text-lg">
                <?php the_content(); ?>
            </div>
        </div>
    </div>
</section>



<?php endwhile; ?>

<div>
    <div class="main-container">
        <?php wpb_posts_nav(); ?>
    </div>
</div>

<?php endif; ?>

<?php
  get_footer();
?>