<?php
  # FROM CONFIG
  $default = get_field("gamma_banner", "options");

  # FROM PAGE
  $banner = get_field("gammas_banner");

  $title = isset($banner) && isset($banner["title"]) && $banner["title"] ? $banner["title"] : $default["title"];
  $text = isset($banner) && isset($banner["text"]) && $banner["text"] ? $banner["text"] : $default["text"];

  # GAMMAS
  $gammas = get_posts(array('post_type' => 'gama', 'order' => 'ASC', 'orderby' => 'post_title', 'numberposts' => '-1', 'exclude' => [get_the_id()], 'suppress_filters' => false));

?>

<section id="other-gamas">
  <div class="main-container my-24">
    <div class="mb-12">
      <h3 class="animate slide-bottom text-darkBlue text-5xl font-bold w-2/3 mb-6"><?= $title; ?></h3>
      <div class="animate slide-bottom delay-200 text-darkBlue text-lg w-full md:w-2/3 lg:w-1/2"><?= wpautop($text); ?></div>
    </div>
    <?php if (isset($gammas) && is_array($gammas) && count($gammas)) : ?>
      <div class="flex items-stretch flex-col flex-wrap md:-mx-3 md:flex-row">
        <?php foreach ($gammas as $key => $gamma) : ?>
          <?php
            $image = get_field("image", $gamma->ID);
            $color = get_field("color", $gamma->ID);
            $description = get_field("short_description", $gamma->ID);
          ?>
          <a href="<?= get_permalink($gamma->ID) ?>" class="animate slide-top delay-<?= $key+1 . "00"; ?> align-self w-full mb-6 md:mb-0 md:p-3 md:w-1/2 xl:w-1/4" aria-label="link to gamma detail page">
            <div class="main-transition h-full bg-white drop-shadow-md hover:drop-shadow-xl">
              <?php if(isset($image) && is_array($image) && count($image)): ?>
                <div class="w-full aspect-video relative">
                  <img src="<?= aq_resize($image['url'], 350, 200, true, true, true); ?>" alt="<?= $image['alt']; ?>" class="w-full h-full object-cover" />
                </div>
              <?php endif; ?>
              <div class="px-4 py-7 border-t-4 lg:px-6" style="border-color: <?= $color; ?>;">
                <h5 class="text-xl font-bold text-darkBlue mb-3 md:mb-5"><?= $gamma->post_title; ?></h5>
                <div class="mb-2 text-sm md:text-xs lg:text-sm text-black/70"><?= wpautop($description); ?></div>
              </div>
            </div>
          </a>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </div>
</section>