<?php
    # FROM CONFIG
    $default = get_field("concepts_banner", "options");

    # FROM PAGE
    $banner = get_field("concepts_banner");

    $title = isset($banner) && isset($banner["title"]) && $banner["title"] ? $banner["title"] : $default["title"];
    $text = isset($banner) && isset($banner["text"]) && $banner["text"] ? $banner["text"] : $default["text"];

    # CONCEPTS
    $args = array('post_type' => 'concept', 'order' => 'ASC', 'orderby' => 'post_title', 'numberposts' => '-1', 'suppress_filters' => false);
    $concepts = get_posts($args);
?>

<?php if(isset($concepts) && is_array($concepts) && count($concepts)): ?>
    <section id="concepts" class="my-20 py-24 xl:py-40 bg-darkBlue">
        <div class="main-container">
            <div class="flex flex-col xl:items-center xl:flex-row">
                <div class="animate slide-right w-full md:w-2/3 pb-12 xl:w-1/3 xl:pr-12">
                    <img src="<?php echo get_template_directory_uri() . "/assets/icons/interrogation.svg" ?>" alt="icon for our custom models" class="w-8" />
                    <h4 class="text-white text-4xl font-semibold mt-10 mb-4"><?= $title; ?></h4>
                    <div class="text-white mt-6 pr-10"><?= wpautop($text); ?></div>
                </div>
                <div class="w-full flex gap-6 items-stretch flex-col md:flex-row xl:w-2/3">
                    <?php foreach ($concepts as $key => $concept): ?>
                        <?php 
                            $icon = get_field("icon", $concept->ID);    
                            $color = get_field("color", $concept->ID);    
                            $name = get_field("short_name", $concept->ID);    
                            $description = get_field("short_description", $concept->ID);    
                        ?>
                        <a href="<?= get_permalink($concept->ID); ?>" class="animate slide-top delay-<?= $key+1 ."00"; ?> border-2 flex-1 align-self relative group" style="border-color: <?= $color; ?>;" aria-label="link to concept detail page">
                            <div class="px-5 py-10">
                                <?php if($icon && $icon["url"]): ?>
                                    <img src="<?= $icon["url"]; ?>" alt="<?= $concept->post_title; ?>" />
                                <?php endif; ?>
                                <h4 class="main-transition text-white font-bold text-base mt-6 group-hover:text-[<?= $color; ?>]"><?= $name; ?></h4>
                                <div class="text-white text-sm mt-2"><?= wpautop($description); ?></div>
                                <div class="absolute inset-0 border-4 opacity-0 main-transition pointer-events-none group-hover:opacity-100" style="border-color: <?= $color; ?>;"></div>
                            </div>
                        </a>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>