<?php
    # FROM CONFIG
  $default = get_field("budget_banner", "options");

  # FROM PAGE
  $banner = get_field("budget_banner");

  $title = isset($banner) && isset($banner["title"]) && $banner["title"] ? $banner["title"] : $default["title"];
  $text = isset($banner) && isset($banner["text"]) && $banner["text"] ? $banner["text"] : $default["text"];
  $formType = isset($banner) && isset($banner["form_type"]) && $banner["form_type"] ? $banner["form_type"] : $default["form_type"];
  $formID = isset($banner) && isset($banner["form_id"]) && $banner["form_id"] ? $banner["form_id"] : $default["form_id"];
  $formZoho = isset($banner) && isset($banner["form_zoho"]) && $banner["form_zoho"] ? $banner["form_zoho"] : $default["form_zoho"];
?>

<section id="ask-for-budget">
    <div class="main-container">
        <div>
            <div class="py-16 md:py-28">
                <div class="max-w-2xl mx-auto">
                    <h3 class="animate slide-top font-bold text-4xl text-darkBlue text-center mx-auto max-w-sm mb-10"><?= $title; ?></h3>
                    <div class="animate slide-top text-center text-lg text-black/80">
                        <?= wpautop($text); ?>
                    </div>
                </div>
                <div class="animate slide-top max-w-3xl mx-auto mt-12 md:mt-20 form-contact delay-300">
                    <?php if($formType === "form"): ?>
                        <?php echo do_shortcode("[contact-form-7 id='" . $formID . "']") ?>
                    <?php elseif($formType === "zoho"): ?>
                        <?php echo do_shortcode('[zohoForms src=' . $formZoho . ' title="zoho form" width=100% height=600px type=js autoheight=true/]'); ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>