<?php
get_header();

$blogID = get_option('page_for_posts', true);
$pageTitle = get_the_title($blogID);

# BANNER
$image = get_field("image", $blogID);
$title = get_field("title", $blogID);
$text = get_field("text", $blogID);
?>

<?php /******** BANNER ********/ ?>
<section id="banner" class="banner pt-6 md:pt-20">
  <div class="relative">
    <div class="main-container block md:flex md:justify-end">
      <div class="animate slide-left image relative w-full md:h-[620px] xl:h-[720px] lg:w-[80%] xl:w-[70%] aspect-video bg-gray overflow-hidden bg-lightGrey">
        <?php if (isset($image) && $image["url"]) : ?>
          <img src="<?= $image["url"] ?>" alt="<?= $image["alt"] ?>" class="h-full w-full object-cover" />
        <?php endif; ?>
      </div>
      <div class="bg-darkBlue relative md:absolute md:bottom-0 md:left-0 md:translate-y-1/2 md:w-[80%] lg:bottom-[unset] lg:-translate-y-1/2 lg:top-1/2 lg:w-2/3 xl:w-1/2">
        <div class="animate slide-right left-padding pt-8 pr-6 md:pt-16 pb-24 lg:py-24 md:pr-20 relative">
          <h2 class="text-white text-5xl font-semibold mb-10"><?= $title ? $title : $pageTitle; ?></h2>
          <p class="text-white max-w-sm mb-10 md:mb-0 "><?= $text; ?></p>
        </div>
      </div>
    </div>
  </div>
</section>

<section id="news" class="pt-20 md:pt-64 pb-20 lg:py-20">
  <div class="main-container">
    <h3 class="animate fade-in text-darkBlue text-4xl mb-8 font-bold"><?php _e("Todos os artigos", "clickhouse-theme"); ?></h3>
    <?php if (have_posts()) : ?>
      <div class="list flex items-stretch flex-wrap flex-row">
        <?php while (have_posts()) : the_post(); ?>
          <a href="<?php the_permalink(); ?>" class="animate slide-top w-full md:w-1/2 xl:w-1/4 align-self">
            <article class="main-transition bg-white h-full w-full hover:shadow-lg">
              <?php if (has_post_thumbnail()) : ?>
                <div class="h-48 relative overflow-hidden">
                  <img src="<?php the_post_thumbnail_url('blog-small'); ?>" alt="<?php the_title(); ?>" class="w-full h-full object-cover">
                </div>
              <?php endif; ?>
              <div class="py-4 px-4">
                <span class="text-xs opacity-40 mb-2 block"><?php echo get_the_date(); ?></span>
                <h3 class="mb-4 font-bold text-xl text-darkBlue"><?php the_title(); ?></h3>
                <div class="text-sm opacity-60"><?php the_excerpt(); ?></div>
              </div>
            </article>
          </a>
        <?php endwhile; ?>
      </div>
      <div class="mt-4 flex justify-center">
        <?php the_posts_pagination(); ?>
      </div>
    <?php else : ?>
      <p><?php _e("Sem artigos para apresentar", "clickhouse-theme"); ?></p>
    <?php endif; ?>
  </div>
</section>

<?php
get_footer();
?>