<?php

require_once('helpers/aq_resizer.php');
require_once('helpers/aq_resizer_helper.php');

/**
 * Hide admin bar from front end
 */
function hide_admin_bar_from_front_end()
{
    if (is_blog_admin()) return true;
    return false;
}
add_filter('show_admin_bar', 'hide_admin_bar_from_front_end');


/**
 *
 * Configurações Gerais
 *
 */
if (function_exists('acf_add_options_sub_page')) {
    acf_add_options_sub_page(array(
        'title' => 'Configurações',
        'capability' => 'edit_posts'
    ));
}
if (function_exists('acf_add_options_sub_page')) {
    acf_add_options_sub_page(array(
        'title' => 'Contactos',
        'capability' => 'edit_posts'
    ));
}
add_theme_support('post-thumbnails');


/**
 * STYLES AND SCRIPTS 
 */
function clickhouse_imports()
{
    wp_enqueue_style('owl', get_template_directory_uri() . '/assets/owl.min.css', array(), '', 'all');
    wp_enqueue_style('style', get_template_directory_uri() . '/dist/styles.min.css', array(), '', 'all');
    // wp_enqueue_script('jquery', get_template_directory_uri() . '/build/js/jquery.min.js', array('jquery'), '', true);
    wp_enqueue_script('owl', get_template_directory_uri() . '/build/js/owl.min.js', array('jquery'), '', true);
    wp_enqueue_script('tailwind', get_template_directory_uri() . '/assets/tailwind.min.js', array('jquery'), '', true);
    wp_enqueue_script('script', get_template_directory_uri() . '/build/js/script.js', array('jquery'), '', true);
}
add_action('wp_enqueue_scripts', 'clickhouse_imports');


/*** GAMA ***/
function gama()
{
    $labels = array(
        'name'                  => _x('Gamas', 'Post Type General Name', 'gama'),
        'singular_name'         => _x('Gama', 'Post Type Singular Name', 'gama'),
        'menu_name'             => __('Gamas', 'gama'),
        'name_admin_bar'        => __('Adicionar Nova Gama', 'gama'),
        'archives'              => __('Arquivo', 'gama'),
        'parent_item_colon'     => __('Item pai', 'gama'),
        'all_items'             => __('Todos', 'gama'),
        'add_new_item'          => __('Adicionar Nova Gama', 'gama'),
        'add_new'               => __('Adicionar Nova', 'gama'),
        'new_item'              => __('Não encontrado', 'gama'),
        'edit_item'             => __('Editar', 'gama'),
        'update_item'           => __('Atualizar', 'gama'),
        'view_item'             => __('Ver', 'gama'),
        'search_items'          => __('Procurar', 'gama'),
        'not_found'             => __('Não Encontrado', 'gama'),
        'not_found_in_trash'    => __('Não Encontrado no Lixo', 'gama'),
        'featured_image'        => __('Imagem de Destaque', 'gama'),
        'set_featured_image'    => __('Definir Imagem de Destaque', 'gama'),
        'remove_featured_image' => __('Remover Imagem de Destaque', 'gama'),
        'use_featured_image'    => __('Usar como Imagem de Destaque', 'gama'),
        'insert_into_item'      => __('Post Types', 'gama'),
        'uploaded_to_this_item' => __('Descarregado para esta página', 'gama'),
        'items_list'            => __('Lista', 'gama'),
        'items_list_navigation' => __('Lista de Navegação', 'gama'),
        'filter_items_list'     => __('Filtrar lista', 'gama'),
    );
    $args = array(
        'label'                 => __('Post Type', 'gama'),
        'description'           => __('Post Type Description', 'gama'),
        'labels'                => $labels,
        'supports'              => array('title', 'content', 'revisions', 'custom_fields'),
        'taxonomies'            => array(''),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_icon'             => 'dashicons-admin-users',
        'menu_position'         => 21,
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => true,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type('gama', $args);
}
add_action('init', 'gama', 0);


/*** CONCEITO ***/
function concept()
{
    $labels = array(
        'name'                  => _x('Conceitos', 'Post Type General Name', 'concept'),
        'singular_name'         => _x('Conceito', 'Post Type Singular Name', 'concept'),
        'menu_name'             => __('Conceitos', 'concept'),
        'name_admin_bar'        => __('Adicionar Novo Conceito', 'concept'),
        'archives'              => __('Arquivo', 'concept'),
        'parent_item_colon'     => __('Item pai', 'concept'),
        'all_items'             => __('Todos', 'concept'),
        'add_new_item'          => __('Adicionar Novo Conceito', 'concept'),
        'add_new'               => __('Adicionar Novo', 'concept'),
        'new_item'              => __('Não encontrado', 'concept'),
        'edit_item'             => __('Editar', 'concept'),
        'update_item'           => __('Atualizar', 'concept'),
        'view_item'             => __('Ver', 'concept'),
        'search_items'          => __('Procurar', 'concept'),
        'not_found'             => __('Não Encontrado', 'concept'),
        'not_found_in_trash'    => __('Não Encontrado no Lixo', 'concept'),
        'featured_image'        => __('Imagem de Destaque', 'concept'),
        'set_featured_image'    => __('Definir Imagem de Destaque', 'concept'),
        'remove_featured_image' => __('Remover Imagem de Destaque', 'concept'),
        'use_featured_image'    => __('Usar como Imagem de Destaque', 'concept'),
        'insert_into_item'      => __('Post Types', 'concept'),
        'uploaded_to_this_item' => __('Descarregado para esta página', 'concept'),
        'items_list'            => __('Lista', 'concept'),
        'items_list_navigation' => __('Lista de Navegação', 'concept'),
        'filter_items_list'     => __('Filtrar lista', 'concept'),
    );
    $args = array(
        'label'                 => __('Post Type', 'concept'),
        'description'           => __('Post Type Description', 'concept'),
        'labels'                => $labels,
        'supports'              => array('title', 'content', 'revisions', 'custom_fields'),
        'taxonomies'            => array(''),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_icon'             => 'dashicons-admin-users',
        'menu_position'         => 21,
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => true,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type('concept', $args);
}
add_action('init', 'concept', 0);

/**
 * MENUS
 */
function clickhouse_menus()
{
    // This theme uses wp_nav_menu() in one <div class="">
    register_nav_menu('primary', 'Menu Principal');
    register_nav_menu('footer', 'Footer Menu');
}
add_action('after_setup_theme', 'clickhouse_menus');

function clickhouse_menu()
{
    wp_nav_menu(apply_filters("clickhouse_menu", array(
        'container' => '',
        'container_id' => 'access',
        'menu_id' => 'main-menu',
        'theme_location' => 'primary'
    )));
}

function clickhouse_menu_footer()
{
    wp_nav_menu(apply_filters("clickhouse_menu", array(
        'container' => '',
        'container_id' => 'access',
        'menu_id' => 'footer-menu',
        'theme_location' => 'footer'
    )));
}

/**
 * Check to see if this page will paginate
 * 
 * @return boolean
 */
function will_paginate()
{
    global $wp_query;

    if (!is_singular()) {
        $max_num_pages = $wp_query->max_num_pages;

        if ($max_num_pages > 1) {
            return true;
        }
    }
    return false;
}

/**
 *   My Functions
 *
 */

function ttruncat($text, $numb)
{
    if (strlen($text) > $numb) {
        $text = substr($text, 0, $numb);
        $text = substr($text, 0, strrpos($text, " "));
        $etc = " ...";
        $text = $text . $etc;
    }
    return $text;
}

function removeHTTP($string)
{
    if (strpos($string, 'http://') !== false) {
        $string = str_replace('http://', '', $string);
    }
    if (strpos($string, 'https://') !== false) {
        $string = str_replace('https://', '', $string);
    }
    if (strpos($string, '/') !== false) {
        $string = substr($string, 0, strpos($string, '/'));
    }
    return $string;
}

function numeric_posts_nav()
{
    if (is_singular())
        return;

    global $wp_query;

    /** Stop execution if there's only 1 page */
    if ($wp_query->max_num_pages <= 1)
        return;

    $paged = get_query_var('paged') ? absint(get_query_var('paged')) : 1;
    $max   = intval($wp_query->max_num_pages);

    /** Add current page to the array */
    if ($paged >= 1)
        $links[] = $paged;

    /** Add the pages around the current page to the array */
    if ($paged >= 3) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }

    if (($paged + 2) <= $max) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }

    echo '<div class="navigation"><ul>' . "\n";

    /** Previous Post Link */
    if (get_previous_posts_link()) {
        printf('<li class="first-link">%s</li>' . "\n", get_previous_posts_link("« ANTERIOR"));
    } else {
        printf('<li class="first-link disabled">%s</li>' . "\n", '<a href="#">« ANTERIOR</a>');
    }
    /** Link to first page, plus ellipses if necessary */
    if (!in_array(1, $links)) {
        $class = 1 == $paged ? ' class="active"' : '';
        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link(1)), '1');
        if (!in_array(2, $links))
            echo '<li>…</li>';
    }

    /** Link to current page, plus 2 pages in either direction if necessary */
    sort($links);
    foreach ((array) $links as $link) {
        $class = $paged == $link ? ' class="active"' : '';
        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($link)), $link);
    }

    /** Link to last page, plus ellipses if necessary */
    if (!in_array($max, $links)) {
        if (!in_array($max - 1, $links))
            echo '<li>…</li>' . "\n";

        $class = $paged == $max ? ' class="active"' : '';
        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($max)), $max);
    }

    /** Next Post Link */
    if (get_next_posts_link()) {
        printf('<li class="last-link">%s</li>' . "\n", get_next_posts_link("PRÓXIMA »"));
    } else {
        printf('<li class="last-link disabled">%s</li>' . "\n", '<a href="#">PRÓXIMA »</a>');
    }
    echo '</ul></div>' . "\n";
}

//design para a pagina wp-admin
function my_login_logo()
{
    $topmenu_logo = get_field('logo', 'Options');
    echo '<style type="text/css">
        #login h1{margin-bottom: 40px;}
        #login h1 a, .login h1 a {background-image:url("' . $topmenu_logo['url'] . '");height:50px;width:265px;background-size:100% auto;background-repeat:no-repeat;padding:0;margin:0 auto;}
        #loginform{box-shadow:none;}
        #loginform input[type=text],#loginform input[type=password] {border:none;border-bottom:1px solid #b8bcbb;font-size:14pt;padding:10px 0;color:#222222;background:#fff;outline:0;box-shadow:none;}
        #loginform input[type=submit]{margin:0;background-color:#2ca2e3;border:2px solid #2ca2e3;color:#fff;font-size:.8em;line-height:1em;font-weight:700;text-transform:uppercase;transition:all 300ms ease;border-radius:0;text-shadow:none;box-shadow:none;}
        #loginform .forgetmenot{margin-top:5px;}
        #loginform input[type=submit]:hover{background-color:transparent;border:2px solid #2ca2e3;color:#2ca2e3;}
        #loginform #rememberme{width:20px;height:20px;-moz-appearance:initial;-webkit-appearance:initial;-o-appearance:initial;border:1px solid #2ca2e3;}
        #loginform #rememberme:focus{outline:0;box-shadow:none;border-color:#2ca2e3;}
        #loginform #rememberme:checked:before{margin:-1px 0 0 -2px;color:#2ca2e3;}
    </style>';
}
add_action('login_enqueue_scripts', 'my_login_logo');

function clickhouse_custom_excerpt_length($length)
{
    return 30;
}
add_filter('excerpt_length', 'clickhouse_custom_excerpt_length', 999);

// add more link to excerpt
function themify_custom_excerpt_more(){
    return ' ...';
}
add_filter('excerpt_more', 'themify_custom_excerpt_more');

function wpb_posts_nav()
{
    $next_post = get_next_post();
    $prev_post = get_previous_post();

    if ($next_post || $prev_post) : ?>

        <div class="flex justify-between mb-10">
            <div>
                <?php if (!empty($prev_post)) : ?>
                    <a href="<?php echo get_permalink($prev_post); ?>" class="animate slide-left main-transition group flex bg-white items-center hover:shadow-lg">
                        <div>
                            <div class="w-36 aspect-square overflow-hidden">
                                <img src="<?php echo get_the_post_thumbnail_url($prev_post, 'blog-small'); ?>" class="main-transition w-full h-full object-cover scale-100 group-hover:scale-105" />
                            </div>
                        </div>
                        <div class="py-4 px-6 w-full max-w-xs">
                            <span class="block text-xs opacity-40"><?php echo get_the_date("d F, Y",  $prev_post); ?></span>
                            <h4 class="text-lg leading-tight"><?php echo get_the_title($prev_post); ?></h4>
                        </div>
                    </a>
                <?php endif; ?>
            </div>
            <div>
                <?php if (!empty($next_post)) : ?>
                    <a href="<?php echo get_permalink($next_post); ?>" class="animate slide-right main-transition group flex bg-white items-center hover:shadow-xl">
                        <div class="py-4 px-6 w-full max-w-xs">
                            <span class="block text-xs opacity-40"><?php echo get_the_date("d F, Y",  $next_post); ?></span>
                            <h4 class="text-lg leading-tight"><?php echo get_the_title($next_post); ?></h4>
                        </div>
                        <div>
                            <div class="w-36 aspect-square overflow-hidden">
                                <img src="<?php echo get_the_post_thumbnail_url($next_post, 'blog-small'); ?>" class="main-transition w-full h-full object-cover scale-100 group-hover:scale-105" />
                            </div>
                        </div>
                    </a>
                <?php endif; ?>
            </div>
        </div> <!-- .wpb-posts-nav -->

<?php endif;
}

/**
 *  LANGUAGES
 */
function language_selector()
{
    $languages = icl_get_languages('skip_missing=0');
    if(!empty($languages)){
        echo "<div class='languages group relative'>";
            echo "<button aria-label='menu languages button' class='mr-8 lg:mr-0 lg:ml-5'>";
                echo "<img src='" . get_template_directory_uri() . "/assets/icons/languages.svg' alt='menu languages icon' class='h-8' />";
            echo "</button>";
            echo "<div class='main-transition absolute right-0 max-w-lg pt-4 pointer-events-none opacity-0 z-10 top-full w-40 inline-block -translate-y-14 group-hover:opacity-100 group-hover:pointer-events-auto group-hover:translate-y-0'>";
                echo "<ul class='bg-darkBlue'>";
                foreach ($languages as $l){
                    echo '<li class="text-center ' . ($l['active'] ? "bg-[#2ca2e3]/40 " : "") . 'hover:bg-[#2ca2e3]"><a href="'. $l['url'] . '" class="block py-4 px-6 text-base text-white">'.$l['native_name'].'</a></li>';
                }
                echo "</ul>";
            echo "</div>";
        echo "</div>";
    }
}

/**
 *
 *   NEWSLETTER AJAX FUNCTION
 */
function jnz_tnp_ajax_subscribe()
{
    if (wp_verify_nonce($_REQUEST['nounce'], 'subscribe')) {
        if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            //check_ajax_referer( 'ajax-nonce', 'subscribe' );

            $msg_success = __('A sua conta foi adicionada com sucesso.', 'bengoji-theme');
            $msg_error = __('Ocorreu um erro. Por favor, tente mais tarde.', 'bengoji-theme');
            $msg_error_email = __('O email inserido já existe nos nossos registos.', 'bengoji-theme');
            $msg_error_email_invalid = __('O email inserido é inválido.', 'bengoji-theme');

            $data = urldecode($_POST['data']);

            if (!empty($data)) :
                $data_array = explode("&", $data);
                $fields = [];
                foreach ($data_array as $array) :
                    $array = explode("=", $array);
                    $fields[$array[0]] = $array[1];
                endforeach;
            endif;

            if (!empty($fields)) :
                if (filter_var($fields['ne'], FILTER_VALIDATE_EMAIL)) :
                    global $wpdb;

                    //check if the email is already in the database
                    $exists = $wpdb->get_var(
                        $wpdb->prepare(
                            "SELECT email FROM " . $wpdb->prefix . "newsletter
                                WHERE email = %s",
                            $fields['ne']
                        )
                    );

                    if (!$exists) {
                        global $wpdb;
                        $wpdb->insert(
                            $wpdb->prefix . 'newsletter',
                            array(
                                'email'         => $fields['ne']
                            )
                        );
                        NewsletterSubscription::instance()->subscribe();

                        $output = array(
                            'status'    => 'success',
                            'msg'       => $msg_success
                        );
                    } else {
                        //email is already in the database
                        $output = array(
                            'status'    => 'error',
                            'msg'       => $msg_error_email
                        );
                    }

                else :
                    $output = array(
                        'status'    => 'error',
                        'msg'       => $msg_error_email_invalid
                    );
                endif;
            else :
                $output = array(
                    'status'    => 'error',
                    'msg'       => $msg_error_email
                );
            endif;


            header('Content-Type: application/json');
            //die($output);
            wp_send_json($output);
        }
    }
}
add_action('wp_ajax_nopriv_ajax_subscribe', 'jnz_tnp_ajax_subscribe');
add_action('wp_ajax_ajax_subscribe', 'jnz_tnp_ajax_subscribe');


function remove_menus()
{
    remove_menu_page('edit-comments.php');
}
add_action('admin_menu', 'remove_menus');
