<?php
get_header();
$pageTitle = get_the_title();

# BANNER
$image = get_field("image");
$title = get_field("title");
$text = get_field("text");
$buttonText = get_field("button_text");

# INTRO
$intro = get_field("intro");
$introImage = get_field("intro_image");
$video = get_field("video");

# ADVANTAGES
$advantages = get_field("advantages");
$advantagesImage = get_field("advantages_image");

# TOPICS
$topics = get_field("topics");

# QUALITY
$quality = get_field("quality_banner");
$qualityVideo = get_field("quality_video");

# SOCIAL
$social = get_field("social_banner");
$socialImages = get_field("social_images");

# SOCIAL
$testimonials = get_field("testimonials");
$testimonialsBanner = get_field("testimonials_banner");

# CONTACTS
$leftBlock = get_field("left_block");
$rightBlock = get_field("right_block");

?>

<?php /******** BANNER ********/ ?>
<section id="banner" class="banner pt-6 md:pt-20">
    <div class="relative">
        <div class="main-container block md:flex md:justify-end">
            <div class="animate slide-left image relative w-full md:h-[620px] xl:h-[720px] lg:w-[80%] xl:w-[70%] aspect-video bg-gray overflow-hidden">
                <?php if (isset($image) && $image["url"]) : ?>
                    <img src="<?= aq_resize($image["url"], 1000, 720, false, true, true); ?>" alt="<?= $image["alt"] ?>" class="h-full w-full object-cover" />
                <?php endif; ?>
            </div>
            <div class="bg-darkBlue relative md:absolute md:bottom-0 md:left-0 md:translate-y-1/2 md:w-[80%] lg:bottom-[unset] lg:-translate-y-1/2 lg:top-1/2 lg:w-2/3 xl:w-1/2">
                <div class="animate slide-right left-padding pt-8 pr-6 md:pt-16 pb-24 lg:py-24 md:pr-20 relative">
                    <h2 class="text-white text-5xl font-semibold mb-10"><?= $title ? $title : $pageTitle; ?></h2>
                    <p class="text-white max-w-sm mb-10 md:mb-0 "><?= $text; ?></p>
                    <?php if (isset($buttonText) && $buttonText) : ?>
                        <a href="#other-gamas" aria-label="button to scroll down" class="button relative md:absolute md:bottom-0 md:translate-y-1/2"><?= $buttonText ?></a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="hidden md:inline-block absolute bottom-0 origin-bottom left-0 -translate-y-full lg:translate-y-1/3 scale-50 lg:left-1/4 xl:scale-100">
                <img src="<?= get_template_directory_uri()."/assets/icons/plant_model_01.png" ?>" alt="plant model example" class="animate slide-left opacity-0 delay-400" />
            </div>
        </div>
    </div>
</section>

<?php /******** INTRO ********/ ?>
<?php if (isset($intro)) : ?>
    <section id="intro" class="mt-20 md:mt-60 lg:mt-40 mb-20">
        <div class="main-container">
            <div class="flex items-center w-full flex-col lg:flex-row">
                <div class="animate slide-right flex-1 pr-0 lg:pr-20 text-darkBlue">
                    <?php if ($intro["title"]) : ?>
                        <h3 class="font-bold text-2xl mb-2"><?= $intro["title"]; ?></h3>
                    <?php endif; ?>
                    <?php if ($intro["description"]) : ?>
                        <div class="mt-8"><?= wpautop($intro["description"]); ?></div>
                    <?php endif; ?>
                </div>
                <?php if (isset($introImage) && isset($introImage["url"])) : ?>
                    <div class="animate slide-left flex-1 mt-20 text-center relative lg:text-left lg:mb-0">
                        <img src="<?= aq_resize($introImage["url"], 680, 530, true, true, true); ?>" alt="<?= $introImage["alt"]; ?>" class="w-full" />
                        <?php if (isset($video) && isset($video["button_text"]) && isset($video["link"])) : ?>
                            <button type="button" aria-label="play button" class="play-button absolute bottom-0 left-1/2 translate-y-1/2 min-w-max whitespace-nowrap -translate-x-1/2 bg-white/80 flex items-center py-4 px-6 backdrop-blur-2xl hover:drop-shadow-lg">
                                <img src="<?= get_template_directory_uri() . "/assets/icons/play.svg" ?>" alt="play button" />
                                <span class="ml-4 text-darkBlue"><?= $video["button_text"]; ?></span>
                            </button>
                            <div class="lightbox">
                                <div class="video-player-front">
                                    <iframe width="1031" height="580" src="<?= $video["link"]; ?>?controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php
get_template_part("parts/part-gamas");
get_template_part("parts/part-concepts-alt");
?>

<?php /******** ADVANTAGES ********/ ?>
<?php if (isset($advantages) && is_array($advantages) && count($advantages)) : ?>
    <section id="advantages" class="mt-20 mb-0 md:mt-32 lg:mt-40 z-10">
        <div class="main-container">
            <div class="flex items-center w-full flex-col lg:flex-row-reverse">
                <div class="animate slide-right flex-1 text-darkBlue">
                    <?php foreach ($advantages as $advantage) : ?>
                        <div class="flex animate slide-left mb-8 max-w-lg w-full lg:max-w-full">
                            <div>
                                <?php if (isset($advantage["icon"]) && isset($advantage["icon"]["url"])) : ?>
                                    <img src="<?= $advantage["icon"]["url"]; ?>" alt="<?= $advantage["icon"]["alt"]; ?>" class="min-w-[42px] xl:min-w-[56px]" />
                                <?php endif; ?>
                            </div>
                            <div class="pl-6 lg:pl-10">
                                <?php if ($advantage["title"]) : ?>
                                    <h6 class="font-bold text-lg mb-2 xl:text-xl"><?= $advantage["title"]; ?></h6>
                                <?php endif; ?>
                                <?php if ($advantage["text"]) : ?>
                                    <div class="mt-2 text-sm xl:mt-8 xl:font-base"><?= wpautop($advantage["text"]); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php if (isset($advantagesImage) && isset($advantagesImage["url"])) : ?>
                    <div class="animate slide-right flex-1 text-center relative pr-0 pt-10 lg:pt-0 z-10 lg:pr-20 lg:text-left">
                        <img src="<?= aq_resize($advantagesImage["url"], 680, 1020, true, true, true); ?>" alt="<?= $advantagesImage["alt"]; ?>" class="max-w-sm w-full  lg:max-w-full" />
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php if (isset($topics) && is_array($topics) && count($topics)) : ?>
    <section id="topics" class="bg-conceptBlue my-20 xl:mt-0 relative xl:before:h-10 xl:before:bg-[#0e1e29] xl:before:absolute xl:before:bottom-full xl:before:w-full">
        <div class="main-container py-20">
            <div class="flex flex-wrap mt-20 lg:mt-8">
                <?php foreach ($topics as $topic) : ?>
                    <div class="flex animate items-start slide-left mb-12 w-full md:pr-6 md:w-1/2 lg:mb-8 lg:w-1/3">
                        <div>
                            <?php if (isset($topic["icon"]) && isset($topic["icon"]["url"])) : ?>
                                <img src="<?= $topic["icon"]["url"]; ?>" alt="<?= $topic["icon"]["alt"]; ?>" class="min-w-[34px] aspect-square object-contain xl:min-w-[48px]" />
                            <?php endif; ?>
                        </div>
                        <div class="pl-6">
                            <?php if ($topic["title"]) : ?>
                                <h6 class="text-white font-bold text-lg mb-2 xl:text-xl"><?= $topic["title"]; ?></h6>
                            <?php endif; ?>
                            <?php if ($topic["text"]) : ?>
                                <div class="text-white/60 mt-2 text-sm xl:font-base"><?= wpautop($topic["text"]); ?></div>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php if (isset($quality)) : ?>
    <section id="quality">
        <div class="main-container">
            <div class="flex items-center w-full flex-col items-stretch lg:flex-row">
                <div class="flex-1 py-20 md:py-20 lg:py-40 pr-0 lg:pr-20 text-darkBlue align-self">
                    <?php if ($quality["title"]) : ?>
                        <h3 class="font-bold text-5xl mb-2 animate slide-top"><?= $quality["title"]; ?></h3>
                    <?php endif; ?>
                    <?php if ($quality["text"]) : ?>
                        <div class="mt-8 mb-8 animate slide-top"><?= wpautop($quality["text"]); ?></div>
                    <?php endif; ?>
                    <?php if (isset($qualityVideo) && isset($qualityVideo["button_text"]) && isset($qualityVideo["link"])) : ?>
                        <button type="button" aria-label="play button" class="button btn-md play-button animate slide-top">
                            <img src="<?= get_template_directory_uri() . "/assets/icons/play.svg" ?>" alt="play button" class="h-10" />
                            <span class="ml-4"><?= $qualityVideo["button_text"]; ?></span>
                        </button>
                        <div class="lightbox">
                            <div class="video-player-front">
                                <iframe width="1031" height="580" src="<?= $qualityVideo["link"]; ?>?controls=0" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="flex-1 relative min-h-[75vh] w-full lg:min-h-[0px] lg:align-self">
                    <?php for ($i = 1; $i <= 7; $i++) : ?>
                        <div class="absolute inset-0 opacity-0 animate slide-left delay-<?= $i * 4; ?>00 delayed">
                            <img src="<?= get_template_directory_uri() . "/assets/animation/parede" . $i . "-min.png"; ?>" alt="<?= $introImage["alt"]; ?>" class="w-full h-full absolute inset-0 object-contain" />
                        </div>
                    <?php endfor; ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php if (isset($social)) : ?>
    <section id="instagram" class="mb-10 md:mb-20 md:pb-32 lg:pb-20 relative">
        <div class="right-container bg-cleanBlue relative">
            <div class="hidden md:inline-block absolute top-20 -left-20 lg:-left-10 scale-75 lg:scale-100 opacity-50">
                <img src="<?= get_template_directory_uri() . "/assets/icons/plant_model_02b.png" ?>" alt="plant model example" class="animate slide-top opacity-0 delay-400" />
            </div>
            <div class="right-padding">
                <div class="max-w-xl lg:max-w-2xl mx-auto pt-12 pl-4 md:pl-0 md:pt-20">
                    <h3 class="font-bold text-4xl md:text-5xl animate slide-bottom animated"><?= $social["title"]; ?></h3>
                </div>
                <?php if (isset($socialImages) && is_array($socialImages) && count($socialImages)) : ?>
                    <div class="flex pt-2 pr-2 gap-2 lg:pt-8 lg:pr-8 lg:gap-8 bg-backBlue translate-y-10 md:translate-y-20 -translate-x-[15%]">
                        <?php foreach ($socialImages as $image) : ?>
                            <div class="flex-1 relative">
                                <?php if (isset($image["url"])) : ?>
                                    <img src="<?= aq_resize($image["url"], 450, 600, true, true, true); ?>" alt="<?= $image["alt"]; ?>" class="w-full h-full aspect-[3/4] object-cover" />
                                <?php endif; ?>
                            </div>
                        <?php endforeach; ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
        <div class="relative mt-14 md:mt-0 md:absolute w-full md:w-auto flex-col md:flex-row flex items-center md:bottom-0 md:left-1/2 backdrop-blur-2xl bg-white/20 md:translate-y-1/2 md:-translate-x-1/2 p-8">
            <span class="inline-block max-w-[260px] text-lg text-darkBlue min-w-[190px] mb-6 md:mb-0 lg:min-w-0"><?= $social["text"]; ?></span>
            <a href="<?= $social["link"]; ?>" aria-label="link to our instagram" class="main-transition button btn-md hover:translate-x-6 md:translate-x-20 hover:md:translate-x-24" target="_blank" rel="noopener noreferrer">
                <span class="whitespace-nowrap"><?= $social["button_text"]; ?></span>
                <img src="<?= get_template_directory_uri() . "/assets/icons/arrow_right.svg" ?>" alt="<?= $social["button_text"]; ?>" class="ml-4 white">
            </a>
        </div>
    </section>
<?php endif; ?>

<?php if (isset($testimonialsBanner)) : ?>
    <section id="testimonials" class="mt-20 md:mt-60 lg:mt-40 mb-20">
        <div class="main-container">
            <div class="flex items-center w-full flex-col lg:flex-row">
                <?php if (isset($testimonials) && is_array($testimonials) && count($testimonials)) : ?>
                    <div class="flex-1 animate slide-right w-full mb-10 lg:w-1/2 lg:mb-0">
                        <div class="owl-carousel bg-white">
                            <?php foreach ($testimonials as $testimonial) : ?>
                                <div class="flex flex-col p-14 justify-between">
                                    <div>
                                        <img src="<?= get_template_directory_uri() . "/assets/icons/quotation_marks_icon.png" ?>" alt="<?= $testimonial["name"]; ?>" class="h-4 !w-auto" />
                                        <div class="mt-4 mb-10 text-base text-darkBlue">
                                            <?= wpautop($testimonial["text"]); ?>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="flex items-center">
                                            <div class="pr-6">
                                                <div class="h-16 aspect-square rounded-full overflow-hidden">
                                                    <img src="<?= aq_resize($testimonial["image"]["url"], 64, 64, true, true, true); ?>" alt="<?= $testimonial["name"]; ?>" class="h-full !w-full object-cover" />
                                                </div>
                                            </div>
                                            <div>
                                                <p class="font-bold text-lg text-darkBlue mb-1"><?= $testimonial["name"]; ?></p>
                                                <?php if (isset($testimonial["stars"]) && !is_nan($testimonial["stars"])) : ?>
                                                    <div class="flex">
                                                        <?php for ($i = 0; $i < $testimonial["stars"]; $i++) : ?>
                                                            <img src="<?= get_template_directory_uri() . "/assets/icons/star_review.png" ?>" alt="star counter" class="h-4 !w-auto" />
                                                        <?php endfor; ?>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="animate slide-left flex-1 pl-0 lg:pl-20 text-darkBlue">
                    <div class="max-w-xl text-center mx-auto lg:text-left lg:max-w-none">
                        <?php if ($testimonialsBanner["title"]) : ?>
                            <h3 class="font-bold text-2xl mb-2"><?= $testimonialsBanner["title"]; ?></h3>
                        <?php endif; ?>
                        <?php if ($testimonialsBanner["text"]) : ?>
                            <div class="mt-8"><?= wpautop($testimonialsBanner["text"]); ?></div>
                        <?php endif; ?>
                        <?php if (isset($testimonialsBanner["button_text"]) && isset($testimonialsBanner["link"])) : ?>
                            <a href="<?= $testimonialsBanner["link"]; ?>" aria-label="link to our testimonials on google maps app" target="_blank" rel="noopener noreferrer" class="button mt-8 btn-md play-button animate slide-top">
                                <span class="whitespace-nowrap"><?= $testimonialsBanner["button_text"]; ?></span>
                                <img src="<?= get_template_directory_uri() . "/assets/icons/arrow_right.svg" ?>" alt="<?= $testimonialsBanner["button_text"]; ?>" class="ml-4 white">
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php
get_template_part("parts/part-budget");
?>

<?php /******** CONTACTS ********/ ?>
<section id="about-contacts">
    <div class="flex flex-col lg:flex-row-reverse">
        <?php if (isset($rightBlock)) : ?>
            <div class="flex-1 pt-40 pb-32">
                <div class="animate slide-bottom right-padding delay-200 pl-6 md:pl-8 lg:pl-20">
                    <?php if (isset($rightBlock["title"])) : ?>
                        <h4 class="text-darkBlue text-3xl font-bold"><?= $rightBlock["title"] ?></h4>
                    <?php endif; ?>
                    <?php if (isset($rightBlock["text"])) : ?>
                        <div class="mt-2 text-darkBlue md:w-2/3">
                            <?= wpautop($rightBlock["text"]); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($rightBlock["franchising"])) : ?>
                        <div class="mt-4">
                            <?php if (isset($rightBlock["franchising"]["title"])) : ?>
                                <h5 class="text-darkBlue text-2xl font-bold"><?= $rightBlock["franchising"]["title"] ?></h5>
                            <?php endif; ?>
                            <?php if (isset($rightBlock["franchising"]["locals"]) && is_array($rightBlock["franchising"]["locals"]) && count($rightBlock["franchising"]["locals"])) : ?>
                                <ul class="mt-2 columns-2 xl:columns-3">
                                    <?php foreach ($rightBlock["franchising"]["locals"] as $local) : ?>
                                        <li class="text-darkBlue leading-relaxed"><?= $local["name"]; ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php endif; ?>
                            <?php if (isset($rightBlock["franchising"]["link"]) && isset($rightBlock["franchising"]["button_text"])) : ?>
                                <div class="mt-10">
                                    <a href="<?= $rightBlock["franchising"]["link"] ?>" class="button" aria-label="link to franchising page">
                                        <?= $rightBlock["franchising"]["button_text"] ?>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        <?php if (isset($leftBlock)) : ?>
            <div class="relative flex-1 bg-darkBlue pt-40 pb-32">
                <div class="animate slide-top left-padding pr-6 md:pr-8 lg:pr-20">
                    <?php if (isset($leftBlock["title"])) : ?>
                        <h4 class="text-white text-4xl font-bold xl:w-2/3"><?= $leftBlock["title"] ?></h4>
                    <?php endif; ?>
                    <?php if (isset($leftBlock["contacts"])) : ?>
                        <div class="mt-6">
                            <ul>
                                <?php if (isset($leftBlock["contacts"]["phone_number"])) : ?>
                                    <li><a href="tel:<?= $leftBlock["contacts"]["phone_number"] ?>" aria-label="direct link to phone number" class="main-transition text-white/80 hover:text-white"><?= $leftBlock["contacts"]["phone_number"] ?></a></li>
                                <?php endif; ?>
                                <?php if (isset($leftBlock["contacts"]["email"])) : ?>
                                    <li><a href="emailto:<?= $leftBlock["contacts"]["email"] ?>" aria-label="direct link to email" class="main-transition text-white/80 hover:text-white"><?= $leftBlock["contacts"]["email"] ?></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($leftBlock["text"])) : ?>
                        <div class="mt-2 text-white/80">
                            <?= wpautop($leftBlock["text"]); ?>
                        </div>
                    <?php endif; ?>
                    <?php if (isset($leftBlock["button_link"]) && isset($leftBlock["button_text"])) : ?>
                        <div class="mt-10">
                            <a href="<?= $leftBlock["button_link"] ?>" class="button" aria-label="link to our contacts page">
                                <?= $leftBlock["button_text"] ?>
                            </a>
                        </div>
                    <?php endif; ?>

                </div>
                <div class="hidden lg:block absolute h-16 bg-darkBlue bottom-0 left-0 right-0 z-10 translate-y-full"></div>
            </div>
        <?php endif; ?>
    </div>
</section>


<?php get_footer(); ?>