<?php
# FOOTER
$logo = get_field("logo_footer", "options");
$text = get_field("text_footer", "options");
$financement = get_field("financement", "options");
$trademark = get_field("trademark", "options");
$copyrights = get_field("copyrights", "options");

$gammas = get_posts(array('post_type' => 'gama', 'order' => 'ASC', 'orderby' => 'post_title', 'numberposts' => '-1', 'suppress_filters' => false));
$concepts = get_posts(array('post_type' => 'concept', 'order' => 'DESC', 'orderby' => 'post_title', 'numberposts' => '-1', 'suppress_filters' => false));
$socials = get_field("socials", "options");

?>
</main>
<footer class="bg-blackBlue pt-32 pb-10 lg:pb-16">
    <div class="main-container">
        <div class="flex flex-col lg:flex-row-reverse">
            <div class="animate slide-top flex-1 flex justify-center gap-6 flex-col md:gap-16 md:flex-row lg:justify-end lg:gap-14 xl:gap-20">
                <div>
                    <h5 class="text-white/60 text-md md:mb-2"><?php _e("Links", "clickhouse-theme"); ?></h5>
                    <?php clickhouse_menu_footer(); ?>
                </div>
                <?php if (isset($concepts) && is_array($concepts) && count($concepts)) : ?>
                    <div>
                        <h5 class="text-white/60 text-md md:mb-2"><?php _e("Concepts", "clickhouse-theme"); ?></h5>
                        <ul>
                            <?php foreach ($concepts as $concept) : ?>
                                <li class="main-transition text-white font-normal text-lg leading-relaxed hover:text-white/60">
                                    <a href="<?= get_permalink($concept->ID); ?>" aria-label="<?= $concept->post_title; ?>"><?= get_field("short_name", $concept->ID); ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?php if (isset($gammas) && is_array($gammas) && count($gammas)) : ?>
                    <div>
                        <h5 class="text-white/60 text-md md:mb-2"><?php _e("Gammas", "clickhouse-theme"); ?></h5>
                        <ul>
                            <?php foreach ($gammas as $gamma) : ?>
                                <li class="main-transition text-white font-normal text-lg leading-relaxed hover:text-white/60">
                                    <a href="<?= get_permalink($gamma->ID); ?>" aria-label="<?= $gamma->post_title; ?>"><?= get_field("short_name", $gamma->ID); ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
                <?php if (isset($socials) && is_array($socials) && count($socials)) : ?>
                    <div>
                        <h5 class="text-white/60 text-md md:mb-2"><?php _e("Siga-nos", "clickhouse-theme"); ?></h5>
                        <ul>
                            <?php foreach ($socials as $social) : ?>
                                <li class="main-transition text-white font-normal text-lg leading-relaxed hover:text-white/60">
                                    <a href="<?= $social["url"]; ?>" target="_blank" rel="noopener noreferrer" aria-label="<?= $social["name"]; ?> link"><?= $social["name"]; ?></a>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
            <div class="animate slide-bottom w-full max-w-md text-center mx-auto mt-20 lg:max-w-full lg:text-left lg:mt-0 lg:w-1/3 lg:pr-4">
                <div class="flex flex-col items-center lg:items-start">
                    <img src="<?= aq_resize($logo["url"], 150, null, false, true, true); ?>" alt="<?= $logo["alt"]; ?>" class="h-8 w-auto" />
                    <div class="mt-4 text-white">
                        <?= wpautop($text); ?>
                    </div>
                </div>
                <?php if (isset($financement)) : ?>
                    <div class="mt-6">
                        <div class="text-white/60 text-sm">
                            <?= wpautop($financement["text"]); ?>
                        </div>
                        <?php if (isset($financement["partners"]) && is_array($financement["partners"]) && count($financement["partners"])) : ?>
                            <div class="flex gap-4 mt-2 justify-center flex-row lg:justify-start">
                                <?php foreach ($financement["partners"] as $partner) : ?>
                                    <?php if ($partner["file"] && isset($partner["file"]["url"])) : ?>
                                        <a href="<?= $partner["file"]["url"]; ?>" target="_blank" aria-label="download partnership report" download>
                                            <?php if (isset($partner["image"]["url"])) : ?>
                                                <img src="<?= aq_resize($partner["image"]["url"], null, 32, false, true, true); ?>" alt="<?= $partner["image"]["alt"]; ?>" class="h-8 w-auto" />
                                            <?php endif; ?>
                                        </a>
                                    <?php else : ?>
                                        <?php if (isset($partner["image"]["url"])) : ?>
                                            <img src="<?= aq_resize($partner["image"]["url"], null, 32, false, true, true); ?>" alt="<?= $partner["image"]["alt"]; ?>" class="h-8 w-auto" />
                                        <?php endif; ?>
                                    <?php endif; ?>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
                <?php if (isset($trademark)) : ?>
                    <div class="mt-6">
                        <div class="text-white/60 text-sm">
                            <?= wpautop($trademark["text"]); ?>
                        </div>
                        <div class="flex mt-2 justify-center flex-row lg:justify-start">
                            <?php if (isset($trademark["url"])) : ?>
                                <a href="<?= $trademark["url"]; ?>" target="_blank" aria-label="trademark website link">
                                <?php endif; ?>
                                <?php if (isset($trademark["image"]["url"])) : ?>
                                    <img src="<?= aq_resize($trademark["image"]["url"], null, 32, true, true, true); ?>" alt="<?= $trademark["image"]["alt"]; ?>" class="h-8 w-auto" />
                                <?php endif; ?>
                                <?php if (isset($trademark["url"])) : ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="mt-6 text-white/60 text-sm">
                    <?= wpautop($copyrights); ?>
                </div>
            </div>
        </div>
    </div>
</footer>

<button id="gototop" class="hidden fixed bottom-8 right-8">
    <img src="<?= get_template_directory_uri() . "/assets/icons/gtt.png" ?>" />
</button>

<?php wp_footer(); ?>
</body>

</html>