jQuery(document).ready(function ($) {
    
    // HEADER CLOSE
    readScroll();
    $(document).on('scroll', function (){
        readScroll();
    });

    // MENU OPEN/CLOSE
    $("button.menu-burguer").on('click', () => {
        $("header .dropdown-menu").toggleClass("opened");
        $("body").toggleClass("blocked");
    });

    // BUTTON TO OPEN VIDEO
    $("body").find("button.play-button").on('click', function(ev) {
        $("body").toggleClass("blocked");
        $(this).parents("section").find(".lightbox").toggleClass("opened");
    });

    // OVERLAY CLICK TO CLOSE LIGHTBOX
    $("body").find("div.lightbox").on('click', function(ev) {
        $("body").removeClass("blocked");
        $(this).removeClass("opened");
    });

    // FAQS ACCORDION
    var i;
    var buttons = document.getElementsByClassName("panel-button");

    for (i = 0; i < buttons.length; i++) {
        buttons[i].addEventListener("click", function () {
            $(this).toggleClass("active");
            $(this).next().toggleClass("active")
        });
    }

    // SCROLL 
    $('body').on('click', 'a[href^="#"]', function (e) {
        e.preventDefault();
        var target = $(this.hash);
        $('html, body').stop().animate({ 'scrollTop': target.offset().top - 140 }, 900, 'swing');
    });
    $('body').on('click', 'button#gototop', function (e) {
        e.preventDefault();
        $('html, body').stop().animate({ 'scrollTop': 0 }, 900, 'swing');
    });

    // ANIMATE
    var elements;
    var windowHeight;

    function init() {
        elements = document.querySelectorAll('.animate');
        windowHeight = window.innerHeight;
    }
    
    function checkPosition() {
        for (var i = 0; i < elements.length; i++) {
          var element = elements[i];
          var positionFromTop = elements[i].getBoundingClientRect().top;
    
          if (positionFromTop - windowHeight <= 0) {
            element.classList.add('animated');
            element.classList.remove('opacity-0');
          }
        }
    }

    // SLIDER
    var owl = $('.owl-carousel');
    owl.owlCarousel({
        items: 1,
        loop: true,
        dots: true,
        autoplay: true,
        autoplayTimeout: 6000,
        autoplayHoverPause: true
    });

    window.addEventListener('scroll', checkPosition);
    window.addEventListener('resize', init);

    init();
    checkPosition();


    function readScroll () {
        var header = $("header");
        var gtt = $("#gototop");
        var scroll = $(document).scrollTop();

        if (scroll >= 300) header.addClass('shortheader');
        else header.removeClass('shortheader');

        if (scroll >= (windowHeight * 2)) gtt.removeClass('hidden');
        else gtt.addClass('hidden');
    }

})